// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: resizeme.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// ResizeMemory class
// resizeable memory manegement class

#ifndef RESIZEME_H
#define RESIZEME_H

#include <stddef.h>		// for size_t

// This class is provided by leck of the C++ realloc feature.
// ResizeMemory class 

typedef int offset;		// i8086 large model
// typedef size_t offset;	// another CPU chip

class ResizeMemory 
{
  // pointer to alloc memory
  void* memory;

  // alloc size
  size_t size;
   
public:
  // constructor
  ResizeMemory(size_t size);
   
  // destructor
  ~ResizeMemory();
   
  // get memory pointer
  void* GetMem() { return memory; }
   
  // i, get memory size
  size_t GetSize() { return size; }
   
  // enlarge alloc memory
  void* EnlargeMemory(ubyte magnification = 2);
   
  // enlarge alloc memory
  void* EnlargeMemory(size_t addendum_size);
   
  // get offset that is relative to alloced memory
  offset GetOffset(void* p);
   
  // get pointer from offset
  void* GetPointer(offset o);
   
  // take memory
  void* TakeMemory();
   
  // free taken memory
  static void FreeMemory(void* mem);
};

const size_t Kilo = 1024;

// ------------------------------------------------------------
// sample operation
// 
// struct sample { int a; int b; int c; void* v; };
// void foo()
// {
//    ResizeMemory rm(1 * Kilo);
//    sample* s = (sample*)rm.GetSize();
//    int* a = &s->a;
//    offset o = GetOffset(&s->a);		// save pointer offset
//    s = rm.EnlargeMemory(1 * Kilo);		// enlarge memory size
//    a = GetPointer(o);			// update pointer
// }

#endif /* RESIZEME_H */
