// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: savepage.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// save pWord Document's page infomation.

#include "pword.h"
#include "tflist.h"
#include "uniqltl.h"
#include "pagemap.h"
#include "layoutte.h"
#include "pagesize.h"
#include "textflow.h"
#include "borderli.h"
#include "fission.h"
#include "fissioni.h"
#include "pstreams.h"
#include "docconte.h"

// save document page infomation.
void 
DocumentContent::WritePageInfo(PStream* stream)
{
  // write header and version
  stream->StartBlockOut(PStream::HDR_PAGEINFO, bw2_save_page_version);
  if (stream->GetError() != SE_NOERROR)
  {
    return;
  }
  
  // save flow number
  uword flow_num = GetTextFlowNum() - GetPanelTextFlowNumber();
  stream->OutUWord(flow_num);		// flow number
  if (stream->GetError() != SE_NOERROR)
  {
    return;
  }
  
  // save layout template info.
  UniqLTList ltlist;
  ltlist.Add(page_size->GetLayoutTemplate());
  for (uword n = 1; n <= pm_num; n++) 
  {
    PageMap* pm = GetPageMap(n);
    ltlist.Add(pm->GetLayoutTemplate());
  }
  
  WriteLayoutTemplateInfo(stream, &ltlist);	// template
  if (stream->GetError() != SE_NOERROR)
  {
    return;
  }
  
  // save page size info.
  page_size->WriteToStream(stream, &ltlist);
  if (stream->GetError() != SE_NOERROR)
  {
    return;
  }
  
  // save page-map info.
  WritePageMapInfo(stream, &ltlist);		// pagemap
  if (stream->GetError() != SE_NOERROR)
  {
    return;
  }
  
  // zero page display start page
  stream->OutUWord(zero_display_start_page);
  if (stream->GetError() != SE_NOERROR)
  {
    return;
  }

  stream->EndBlockOut();
}

// save template infomation
void 
DocumentContent::WriteLayoutTemplateInfo(PStream* stream, UniqLTList* ltlist)
{
  uword lt_num = ltlist->Number();
  stream->OutUWord(lt_num);	// template number
  if (stream->GetError() != SE_NOERROR)
  {
    return;
  }
  for (uword n = 1; n <= lt_num; n++) 
  {
    LayoutTemplate* lt = ltlist->GetLT(n);
    lt->WriteToStream(stream);
    if (stream->GetError() != SE_NOERROR)
    {
      return;
    }
  }
}

// save page-map infomation
void 
DocumentContent::WritePageMapInfo(PStream* stream, UniqLTList* ltlist)
{
  stream->OutUWord(pm_num);	// page-map number
  if (stream->GetError() != SE_NOERROR)
  {
    return;
  }
  for (uword n = 1; n <= pm_num; n++) 
  {
    PageMap* pm = GetPageMap(n);
    pm->WriteToStream(stream, ltlist);
    if (stream->GetError() != SE_NOERROR)
    {
      return;
    }
  }
}

// read page infomation
void 
DocumentContent::ReadPageInfo(PStream* stream)
{
  // read header and version
  word version;
  stream->StartTypedBlockIn(PStream::HDR_PAGEINFO, version);
  
  // read flow number
  uword flow_num = stream->InUWord();		// flow number
  CHECK;
  for (uword n = 1; n <= flow_num; n++) 
  {
    // create text-flow
    new TextFlow(this);
  }
  
  // restore layout template
  UniqLTList ltlist;
  ReadLayoutTemplateInfo(stream, &ltlist);	// template
  CHECK;
  
  // restore page size
  page_size = PageSize::ReadFromStream(stream, this, &ltlist);
  CHECK;
  
  // restore page-map
  ReadPageMapInfo(stream, &ltlist);		// pagemap
  CHECK;
  
  if (version >= bw2_save_page_version)
  {
    // zero page display start page
    zero_display_start_page = stream->InWord();
    CHECK;
  }
  stream->EndBlockIn();
}

void 
DocumentContent::ReadLayoutTemplateInfo(PStream* stream, UniqLTList* ltlist)
{
  uword lt_num = stream->InUWord();	// template number
  CHECK;
  for (uword n = 1; n <= lt_num; n++) 
  {
    // restore one template
    LayoutTemplate* lt = LayoutTemplate::ReadFromStream(stream, this);
    CHECK;
    ltlist->Add(lt);
  }
}

void 
DocumentContent::ReadPageMapInfo(PStream* stream, UniqLTList* ltlist)
{
  uword pm_num = stream->InUWord();	// page-map number
  CHECK;
  for (uword n = 1; n <= pm_num; n++) 
  {
    // read one page-map
    PageMap* pm = PageMap::ReadFromStream(0, stream, this, ltlist, 0);
    CHECK;
    
    AddPageMap(pm);
  }
}

// generate page
void 
DocumentContent::GeneratePage()
{
  page_size->Initialize();
  for (uword n = 1; n <= pm_num; n++) 
  {
    PageMap* pm = GetPageMap(n);
    pm->GeneratePage();
  }
}
