// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: screen.cpp,v 3.3 1999/07/25 08:34:48 kudou Exp $
// screen

// to get our hands on the OBM_CLOSE bitmap
#define OEMRESOURCE

#include "pword.h"
#include "screen.h"

// system colors
DWORD Screen::button_face_color = 0;
DWORD Screen::button_shadow_color = 0;
DWORD Screen::button_text_color = 0;
DWORD Screen::pushed_button_color = 0;
DWORD Screen::pushed_text_color = 0;

int Screen::width = 0;
int Screen::height = 0;
int Screen::caption_height = 0;
int Screen::caption_bitmap_height = 0;
int Screen::frame_width = 0;
int Screen::frame_height = 0;
int Screen::vscroll_bitmap_width = 0;
int Screen::hscroll_bitmap_height = 0;
int Screen::kanji_window_height = 0;
int Screen::closebox_bitmap_width = 0;
int Screen::closebox_bitmap_height = 0;
int Screen::system_font_height = 0;

HDC Screen::dc = 0;

HBRUSH Screen::primary_background_brush = 0;
HBRUSH Screen::secondary_background_brush = 0;

HBRUSH Screen::white_brush = 0;
HBRUSH Screen::black_brush = 0;
HBRUSH Screen::simple_dotted_brush[2] = {0, 0,};
HBRUSH Screen::simple_broken_brush[2] = {0, 0,};
HBRUSH Screen::invisible_line_brush_h = 0;
HBRUSH Screen::invisible_line_brush_v = 0;
HBRUSH Screen::one_dot_brush = 0;
HBRUSH Screen::selected_frame_brush = 0;

HBRUSH Screen::stocked_black_brush = 0;
HBRUSH Screen::stocked_dark_gray_brush = 0;
HBRUSH Screen::stocked_gray_brush = 0;
HBRUSH Screen::stocked_light_gray_brush = 0;
HBRUSH Screen::stocked_white_brush = 0;

HFONT Screen::system_font = 0;
HFONT Screen::vertical_system_font = 0;

static void NEAR
kill_object(HANDLE h)
{
  if (h)
  {
    ::DeleteObject(h);
  }
}

void
Screen::KillAllResources()
{
  static HANDLE* handle_ptrs[] =
  {
    (HANDLE*) &Screen::invisible_line_brush_h,
    (HANDLE*) &Screen::invisible_line_brush_v,
    (HANDLE*) &Screen::one_dot_brush,
    (HANDLE*) &Screen::simple_broken_brush[INDEX_HORIZONTAL],
    (HANDLE*) &Screen::simple_broken_brush[INDEX_VERTICAL],
    (HANDLE*) &Screen::simple_dotted_brush[INDEX_HORIZONTAL],
    (HANDLE*) &Screen::simple_dotted_brush[INDEX_VERTICAL],
    (HANDLE*) &Screen::black_brush,
    (HANDLE*) &Screen::white_brush,
    (HANDLE*) &Screen::secondary_background_brush,
    (HANDLE*) &Screen::primary_background_brush,
    (HANDLE*) &Screen::vertical_system_font,
    (HANDLE*) NULL,
  };
  
  HANDLE** pp = handle_ptrs;
  for (;;)
  {
    HANDLE* p = *pp++;
    if (p == NULL)
    {
      break;
    }
    kill_object(*p);
  }
       
  if (Screen::dc)
  {
    ::DeleteDC(Screen::dc);
  }
}

static DWORD NEAR
get_nearest_color(DWORD color)
{
  return(::GetNearestColor(Screen::dc, color));
}

static DWORD NEAR
get_system_color(int a)
{
  return(::GetSysColor(a));
}

// public interface
void
Screen::get_system_colors()
{
  Screen::button_shadow_color = get_system_color(COLOR_BTNSHADOW);
  
  Screen::button_face_color =
  get_nearest_color(get_system_color(COLOR_BTNFACE));
  
  Screen::button_text_color =
  get_nearest_color(get_system_color(COLOR_BTNTEXT));

  if (Screen::button_text_color == Screen::button_face_color)
  {
    Screen::button_text_color = (Screen::button_face_color != BLACK ? BLACK
				 : WHITE);
  }
  
  Screen::pushed_button_color = (Screen::button_face_color != WHITE ? WHITE
				 : BLACK);
  
  Screen::pushed_text_color = Screen::button_text_color;
  if (Screen::pushed_text_color == Screen::pushed_button_color)
  {
    Screen::pushed_text_color = (Screen::pushed_button_color != BLACK ? BLACK
				 : WHITE);
  }
}

// public interface
void
Screen::Init()
{
  {
    struct MetricTable
    {
      int* place;
      int code;
    };
    
    static MetricTable metric_table[] =
    {
      {&Screen::width, SM_CXSCREEN,},
      {&Screen::height, SM_CYSCREEN,},
      {&Screen::caption_height, SM_CYCAPTION,},
      {&Screen::caption_bitmap_height, SM_CYSIZE,},
      {&Screen::frame_width, SM_CXFRAME,},
      {&Screen::frame_height, SM_CYFRAME,},
      {&Screen::vscroll_bitmap_width, SM_CXVSCROLL,},
      {&Screen::kanji_window_height, SM_CYKANJIWINDOW,},
      {&Screen::hscroll_bitmap_height, SM_CYHSCROLL,},
      {NULL,},
    };
    
    MetricTable* p = metric_table;
    int* place;
    while ((place = p->place) != NULL)
    {
      *place = ::GetSystemMetrics(p->code);
      ++p;
    }
    
    // windows bug??
    if (kanji_window_height == 0)
    {
      kanji_window_height = hscroll_bitmap_height;
    }
  }

  // get size of close box bitmap
  HANDLE sysmenu_bitmap = ::LoadBitmap(NULL, MAKEINTRESOURCE(OBM_CLOSE));
  BITMAP my_bitmap;
  ::GetObject(sysmenu_bitmap, sizeof(BITMAP), (LPSTR) (LPBITMAP) &my_bitmap);
  closebox_bitmap_height = my_bitmap.bmHeight;
  closebox_bitmap_width = my_bitmap.bmWidth/2;
  ::DeleteObject(sysmenu_bitmap);
  
  Screen::dc = ::CreateDC("DISPLAY", NULL, NULL, NULL);
  
  Screen::primary_background_brush = ::CreateSolidBrush(PRIMARY_BACKGROUND);
  
  Screen::secondary_background_brush
  = ::CreateSolidBrush(SECONDARY_BACKGROUND);
  
  {
    struct SimpleBrushTable
    {
      HBRUSH* place;
      short pattern[8];
    };
    
    static SimpleBrushTable simple_brush_table[] =
    {
      {
	&Screen::white_brush,
	// ________
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, },
      },
      {
	&Screen::black_brush,
	// 00000000
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
      },
      {
	&Screen::simple_dotted_brush[INDEX_HORIZONTAL],
#ifdef BW3_LINEPAT
	// 000_____
	{ 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, },
#else /* BW3_LINEPAT */
        // 00__00__
	{ 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, },
#endif /* BW3_LINEPAT */
      },
      {
	&Screen::simple_dotted_brush[INDEX_VERTICAL],
#ifdef BW3_LINEPAT
	// 000_____
	{ 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, },
#else /* BW3_LINEPAT */
	// 00__00__
	{ 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, },
#endif /* BW3_LINEPAT */
      },
      {
	&Screen::simple_broken_brush[INDEX_HORIZONTAL],
#ifdef BW3_LINEPAT
	// 000000__
	{ 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, },
#else /* BW3_LINEPAT */
	// 0000____
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, },
#endif /* BW3_LINEPAT */
      },
      {
	&Screen::simple_broken_brush[INDEX_VERTICAL],
#ifdef BW3_LINEPAT
	// 000000__
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, },
#else /* BW3_LINEPAT */
	// 0000____
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, },
#endif /* BW3_LINEPAT */
      },
      {
	&Screen::invisible_line_brush_h,
	// 0___0___
	{ 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, },
      },
      {
	&Screen::invisible_line_brush_v,
	// 0___0___
	{ 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, },
      },
      {
	&Screen::one_dot_brush,
	// _0_00_0_
	{ 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, },
      },
      {
	&Screen::selected_frame_brush,
	// 0___ ____
	{ 0x77, 0xff, 0xdd, 0xff, 0x77, 0xff, 0xdd, 0xff, },
      },
      {NULL,},
    };
    
    SimpleBrushTable* p = simple_brush_table;
    HBRUSH* place;
    while ((place = p->place) != NULL)
    {
      HBITMAP bitmap = ::CreateBitmap(8, 8, 1, 1, (LPSTR) p->pattern);
      *place = ::CreatePatternBrush(bitmap);
      kill_object(bitmap);
      ++p;
    }
  }
  
  {
    struct StockedObjectTable
    {
      HANDLE* place;
      int code;
    };
    
    static StockedObjectTable stocked_object_table[] =
    {
      {(HANDLE*) &Screen::stocked_black_brush, BLACK_BRUSH,},
      {(HANDLE*) &Screen::stocked_dark_gray_brush, DKGRAY_BRUSH,},
      {(HANDLE*) &Screen::stocked_gray_brush, GRAY_BRUSH,},
      {(HANDLE*) &Screen::stocked_light_gray_brush, LTGRAY_BRUSH,},
      {(HANDLE*) &Screen::stocked_white_brush, WHITE_BRUSH,},
      {(HANDLE*) &Screen::system_font, SYSTEM_FONT,},
      {NULL, 0,},
    };
    
    StockedObjectTable* p = stocked_object_table;
    HANDLE* place;
    while ((place = p->place) != NULL)
    {
      *place = ::GetStockObject(p->code);
      ++p;
    }
  }

  {
    TEXTMETRIC tm[1];
    HFONT old_font = (HFONT)::SelectObject(Screen::dc, Screen::system_font);
    ::GetTextMetrics(dc, tm);
    ::SelectObject(Screen::dc, old_font);
    Screen::system_font_height = tm->tmAscent + tm->tmDescent;
    SET_MAX(Screen::system_font_height, 1);
  }
  
  // Create vertical system font
  {
    LOGFONT lf;
    ::GetObject(Screen::system_font, sizeof(lf), (char*) &lf);
    lf.lfEscapement = 270 * 10;
    lf.lfOrientation = 270 * 10;
    if (lf.lfFaceName[0] != '@')
    {
      memmove(&lf.lfFaceName[1],
	       &lf.lfFaceName[0], sizeof(lf.lfFaceName) - 1);
      lf.lfFaceName[0] = '@';
    }
    Screen::vertical_system_font = CreateFontIndirect(&lf);
  }
  Screen::get_system_colors();
}
