// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: searchdl.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implementation of SearchDialog class

#include "pword.h"
#include "searchdl.h"
#include "dialogs.h"
#include "document.h"
#include "mwindow.h"
#include "pmenus.h"
#include "pref.h"
#include "screen.h"

// public constructor
SearchDialog::SearchDialog()
{
  this->class_name = "PSearch";
  this->reverse = False;
  this->all = False;
  this->string[0] = '\0';
}

// private method
void NEAR
SearchDialog::update()
{
  if (GetHandle() != 0)
  {
    int chars = GetItemText(IDD_SEARCHSTRING, string, SEARCHSTRINGMAX - 1);
    string[chars] = '\0';
    EnableWindow(GetItem(IDOK), string[0] != '\0');
  }
}

void
SearchDialog::set_string(char* s)
{
  copy_string(string, s, sizeof(string));
  Pref_search_string10.add_string(s);
  HWND handle = this->GetHandle();
  if (handle != 0)
  {
    Pref::set_item_string10(handle, IDD_SEARCHSTRING, &Pref_search_string10);
    SetItemText(IDD_SEARCHSTRING, Pref_search_string10.get_string(0));
    update();
  }
}

void
SearchDialog::Go()
{
  if (this->GetHandle() == 0)
  {
    PModelessDialog::Go();
  }
  this->set_string(NULL);
  ::SetFocus(this->GetItem(IDD_SEARCHSTRING));
  this->BringToTop();
  Show();
}

LRESULT_T
SearchDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  THIS_CHECK;
  switch (Msg)
  {
   case WM_INITDIALOG:
    update();
    return 1;
    
    // WM_CLOSE comes when the user closes the box with the Close
    // command from the control menu
    
   case WM_CLOSE:
    Hide();
    return 1;
    
   case WM_COMMAND:	
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDD_SEARCHSTRING:
#ifdef _WIN32
      switch (HIWORD(wParam))
#else /* _WIN32 */
      switch (HIWORD(lParam))
#endif /* _WIN32 */
      {
       case CBN_EDITCHANGE:
       case CBN_EDITUPDATE:
	update();
	break;
       case CBN_SELCHANGE:
	{
	  WORD i = (WORD)SendItemMessage(IDD_SEARCHSTRING, CB_GETCURSEL);
	  if (i != (WORD)CB_ERR)
	  {
	    SendItemMessage(IDD_SEARCHSTRING, CB_GETLBTEXT, i, (LONG)string);
	    SendItemMessage(IDD_SEARCHSTRING, WM_SETTEXT, 0, (LONG)string);
	    EnableWindow(GetItem(IDOK), string[0] != '\0');
	  }
	}
	break;
      }
      break;
      
     case IDOK:
      if (Selected_Document == NULL || string[0] == '\0')
      {
	::MessageBeep(0);
      }
      else
      {
	Hide();
	main_window->Update();
	dispatch_simple_command(IDM_Location_FindGo);
	// manage list of recent search strings, adding and writing
	Pref_search_string10.add_string(string);
	Pref::set_item_string10(this->GetHandle(),
				 IDD_SEARCHSTRING, &Pref_search_string10);
      }
      return(1);
      
     case IDD_SEARCHREVERSE:
      reverse = (bool)(get_item_check(IDD_SEARCHREVERSE) != 0);
      return 1;
      
     case IDD_SEARCHALL:
      all = (bool)(get_item_check(IDD_SEARCHALL) != 0);
      EnableWindow(GetItem(IDD_SEARCHREVERSE), !all);
      return 1;
      
     case IDCANCEL:
      // on Cancel, do not save new settings
      Hide();
      return 1;
    }
  }
  return 0;
}
