// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: seeds.h,v 3.3 1999/05/12 00:22:16 kudou Exp $
// Shrinked FrameObject for file save/load.
// These classes are used in BluePrint. 

#ifndef SEEDS_H
#define SEEDS_H

#include "objectid.h"
#include "attribut.h"		// enum VerticalAlignment
#include <stddef.h>

// these classes are used when frame-object save or load.

class FrameObject;

// ------------------------------------------------------------
// all seed base class

class Seed
{
  // seed data
  ObjectID id;
  
  // margin
  Margin margin;
  
public:
  // file save version
  enum 
  {
    sv_luna	= 1,		// luna version(don't save header)
    sv_snow	= 2,		// snow version
    sv_bw1	= 3,		// BeatWord Ver.1 
    sv_bw2	= 4,		// BeatWord Ver.2
    sv_bw3	= 5,		// BeatWord Ver.3
#ifdef BW3
    save_version = sv_bw3,
#else /* BW3 */
    save_version = sv_bw2,
#endif /* BW3 */
  };
  
  // constructor
  Seed(FrameObject* fo);
  
  // constructor for make template
  Seed(ObjectID id, Margin& m);
  
  // generate seed
  static Seed* GenerateSeed(FrameObject* fo);
  
  // save seed data
  void Save(PStream* ps);
  
  // load seed data
  static Seed* Load(PStream* ps, int version);
  
  // accessor
  ObjectID GetID() 
  {
    return id;
  }
  
  Iunit GetTopMargin()    
  {
    return margin.GetTop();
  }
  
  Iunit GetBottomMargin() 
  {
    return margin.GetBottom();
  }
  
  Iunit GetLeftMargin()   
  {
    return margin.GetLeft();
  }
  
  Iunit GetRightMargin()  
  {
    return margin.GetRight();
  }
  
  Margin GetMargin() 
  {
    return margin;
  }
};

// ------------------------------------------------------------
// text frame object seed

// for old file read
typedef Seed OLDTextSeed;

class TextSeed 
  : public Seed 
{
  VerticalAlignment frame_align;
  
public:
  // constructor
  TextSeed(FrameObject* fo);
  
  // constructor for load file
  TextSeed(Margin& m);
  
  // destructor
  ~TextSeed() 
  { ; }
  
  // save seed data
  void Save(PStream* ps);
  
  // load seed data
  static Seed* Load(PStream* ps, Margin& m, int seed_version);
  
  VerticalAlignment FrameAlign() { return frame_align; }
};

// ------------------------------------------------------------
// fill frame object seed

class FillSeed 
  : public Seed 
{
  // seed data
  FillObject::FillType typ;
  
public:
  // constructor
  FillSeed(FrameObject* fo);
  
  // constructor for load file
  FillSeed(Margin& m) 
  : Seed(IDFillObject, m) 
  { ; }
  
  // constructor for make template
  FillSeed(FillObject::FillType t);
  
  // destructor
  ~FillSeed() 
  { ; }
  
  // save seed data
  void Save(PStream* ps);
  
  // load seed data
  static Seed* Load(PStream* ps, Margin& m, int seed_version);
  
  // accessor
  FillObject::FillType GetFillType() 
  {
    return typ;
  }
};

// ------------------------------------------------------------
// graphic frame object seed

class GraphicSeed 
  : public Seed 
{
  // CF_DIB data
  VMem* vm_dib;
  
  // CF_DIB size
  udword dib_size;
  
  // reference data flag
  bool ref_flag;
  
public:
  // constructor
  GraphicSeed(FrameObject* fo);
  
  // constructor for file load
  GraphicSeed(Margin& m);
  
  // desturctor
  ~GraphicSeed();
  
  // save seed data
  void Save(PStream* ps);
  
  // load seed data
  static Seed* Load(PStream* ps, Margin& m, int seed_version);
  
  void SetVMDIB(VMem* v) 
  {
    vm_dib = v;
  }
  
  VMem* GetVMDIB() 
  {
    return vm_dib;
  }
  
  udword GetDIBSize() 
  {
    return dib_size;
  }
};

// ------------------------------------------------------------
// all layout seed

class AllLayoutSeed 
  : public Seed 
{
public:
  // constructor
  AllLayoutSeed(FrameObject* fo);
  
  // constructor for file load
  AllLayoutSeed(Margin& m)
  : Seed(IDAllLayoutObject, m) 
  { ; }
  
  // constructor for make template
  AllLayoutSeed(uword dummy);
  
  // desturctor
  ~AllLayoutSeed() 
  { ; }
  
  // save seed data
  void Save(PStream* ps);
  
  // load seed data
  static Seed* Load(PStream* ps, Margin& m, int seed_version);
};

// ------------------------------------------------------------
// metafile object seed

class MetafileSeed 
  : public Seed 
{
  // metafile info
  METAFILEPICT mp;
  
  // metafile size
  DWORD metafile_size;
  
  // reference data flag
  bool ref_flag;
  
public:
  // constructor
  MetafileSeed(FrameObject* fo);
  
  // constructor for file load
  MetafileSeed(Margin& m);
  
  // constructor for make template
  MetafileSeed(uword dummy);
  
  // desturctor
  ~MetafileSeed();
  
  // save seed data
  void Save(PStream* ps);
  
  // load seed data
  static Seed* Load(PStream* ps, Margin& m, int seed_version);
  
  // copy metafilepict
  METAFILEPICT* CopyMETAFILEPICT();
};

// ------------------------------------------------------------
// unknown object seed

class UnknownSeed 
  : public Seed 
{
  // for seed read error
  bool err; 
  
public:
  // constructor
  UnknownSeed(FrameObject* fo);
  
  // constructor for file load
  UnknownSeed(Margin& m, bool err = False);
  
  // constructor for make template
  UnknownSeed(uword dummy);
  
  // desturctor
  ~UnknownSeed() 
  { ; }
  
  // save seed data
  void Save(PStream* ps);
  
  // get err
  bool GetError() 
  {
    return err;
  }
  
  // load seed data
  static Seed* Load(PStream* ps, Margin& m, int seed_version);
};

#endif /* SEEDS_H */
