// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: setflow.cpp,v 3.3 1999/05/23 17:26:08 kudou Exp $
// class EditFrame
// t[GfB^̃t[ݒҏW[h

#include "pword.h"
#include "editfram.h"
#include "pmenus.h"
#include "mcursor.h"
#include "docwindo.h"
#include "frameown.h"
#include "frametem.h"
#include "frameins.h"
#include "layoutte.h"
#include "layoutin.h"
#include "objectid.h"
#include "vdisplay.h"
#include "xstr.h"

void NEAR 
EditFrame::SetFlow_LDWN(WPARAM_T /*wParam*/, LPARAM_T lParam)
{
  //
  // start fix
  //
  flow.Reset();
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  FrameObject* fo = 0;
  if ((LockLayout(mpos) == 0) || 
      ((fo = FindFrameObjectW(mpos)) == 0)) 
  {
    CancelSetFlow();
    return;
  }
  flow.SetStart(fo->GetCrossPoint(), WtoLv(mpos), WtoIv(mpos));
  RedisplaySetFlow();
  MouseCursor::SetPipeToEmpty();
}

void NEAR 
EditFrame::SetFlow_MV(WPARAM_T /*wParam*/, LPARAM_T lParam)
{
  if (flow.IsFixed() == False) 
  {
    //
    // idle
    //
    flow.Reset();
    VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
    if ((LockLayout(mpos) == 0) || 
	(FindFrameObjectW(mpos) == 0)) 
    {
      MouseCursor::SetPipeOff();
    }
    else 
    {
      MouseCursor::SetPipe();
    }
  }
  else 
  {
    //
    // move
    //
    VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
    RedisplaySetFlow();		// vanish
    flow.SetEndPos(WtoLv(mpos));
    RedisplaySetFlow();		// draw
    CrossPoint* cp = 0;
    if ((FindLayoutW(mpos) != GetEditLI()) ||
	((cp = FindCrossPointW(mpos)) == 0) ||
	(cp == flow.GetSource())) 
    {
      MouseCursor::SetPipeToEmpty();
      flow.SetDestination(0);
    }
    else 
    {
      MouseCursor::SetPipeTo();
      flow.SetDestination(cp);
    }
  }
}

void NEAR 
EditFrame::SetFlow_LUP(WPARAM_T wParam, LPARAM_T lParam)
{
  if (flow.IsFixed() == False) 
  {
    CancelSetFlow(False);
    return;
  }
  
  SetFlow_MV(wParam, lParam);
  
  CrossPoint* cp = flow.GetDestination();
  if (cp == 0) 
  {
    CancelSetFlow();
    return;
  }
  
  FrameObject* fo = cp->GetFrameObject();
  if ((fo != 0) && (fo->CheckVanish() == False)) 
  {
    // can't clear this object.
    Issue(S_CantDeleteFrameMsg, MB_OK | MB_ICONEXCLAMATION);
    CancelSetFlow();
    return;
  }
  
  MouseCursor::SetPipeOff();
  RedisplaySetFlow();		// vanish
  CrossPoint *source_cp = flow.GetSource();
  if (GetEditLT() ->IsTable() || GetEditLT() ->IsZeroPage())
  {
    FrameObject *fo = source_cp->GetFrameObject();
    if (fo && (ObjectID) fo->GetObjectID() == IDTextObject)
    {
      FrameInstance *fi = (GetEditLI()
			   ->FindFIByFT((FrameTemplate *) fo));
      if (fi)
      {
	fi->DelayFormat();
      }
    }
  }
  now_set_flow = True;
  edit_ff->FlowTo(source_cp, cp);
  now_set_flow = False;
  
  flow.Reset();
  UnforceTouchCaret();
  RedrawWindows();
  SetDirty();
}

void
EditFrame::WndProcSetFlow(DocumentWindow* window, 
			   MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  EditFrame::window = window;
  switch (Msg) 
  {
   case WM_LBUTTONDOWN:
    SetFlow_LDWN(wParam, lParam);
    break;
    
   case WM_MOUSEMOVE:
    SetFlow_MV(wParam, lParam);
    break;
    
   case WM_LBUTTONUP:
    SetFlow_LUP(wParam, lParam);
    break;
    
   case WM_RBUTTONDOWN:
    CancelSetFlow(False);
    break;
  }
}

void 
EditFrame::CancelSetFlow(bool beep)
{
  if (flow.IsFixed()) 
  {
    RedisplaySetFlow();		// vanish
  }
  MouseCursor::SetPipeOff();
  flow.Reset();
  if (beep) 
  {
    ::MessageBeep(0);
  }
}

// display set-flow object
void 
EditFrame::RedisplaySetFlow()
{
  HWND hWnd = window->GetHandle();
  HDC hDC = GetDC(hWnd);
  RedisplaySetFlow(hDC);
  ReleaseDC(hWnd, hDC);
}

// display set-flow object
void 
EditFrame::RedisplaySetFlow(VDisplay* vdsp)
{
  if (flow.IsFixed()) 
  {
    RedisplaySetFlow(vdsp->GetDC());
  }
}

// display set-flow object
void 
EditFrame::RedisplaySetFlow(HDC hDC)
{
  SetROP2(hDC, R2_NOT);
#ifdef _WIN32
  MoveToEx(hDC, ItoWx(flow.GetFromX()), ItoWy(flow.GetFromY()), NULL);
#else /* _WIN32 */
  MoveTo(hDC, ItoWx(flow.GetFromX()), ItoWy(flow.GetFromY()));
#endif /* _WIN32 */
  LineTo(hDC, LtoWx(flow.GetToLX()), LtoWy(flow.GetToLY()));
}
