// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: sjis.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// Shift JIS

#ifndef SJIS_H
#define SJIS_H

// ------------------------------------------------------------
// replace of jctype.h

// Following 3 macros evaluate argument multiple.

#undef iskana
#define iskana(c) (0xa0 <= (unsigned char) (c) && (unsigned char) (c) < 0xe0)

#undef iskanji
#define iskanji(c) \
(0x81 <= (unsigned char) (c) \
 && ((unsigned char) (c) <= 0x9f \
     || (0xe0 <= (unsigned char) (c) && (unsigned char) (c) <= 0xfc)))

#undef iskanji2
#define iskanji2(c) \
(0x40 <= (unsigned char) (c) \
 && (unsigned char) (c) <= 0xfc && (unsigned char) (c) != 0x7f)

// ------------------------------------------------------------
// low level character predicates

#define SJIS_KANJI_MASK ((unsigned int) 0x8000)
#define SJIS_SPECIAL_TYPE_MASK ((unsigned int) 0xf000)
#define SJIS_CHARACTER_SET_MASK ((unsigned int) 0xff00)

#define SJIS_SPECIAL_CODE_MASK ((unsigned int) ~SJIS_SPECIAL_TYPE_MASK)
#define SJIS_CHARACTER_CODE_MASK ((unsigned int) ~SJIS_CHARACTER_SET_MASK)

#define SJIS_SPECIAL_CODE_MAX ((unsigned int) SJIS_SPECIAL_CODE_MASK)

// special type value.

#define SJIS_PANEL_SPECIAL ((unsigned int) 0x1000)

// character set value.

// ANSI(ascii and high ansi) character
#define SJIS_ANSI_CHARACTER ((unsigned int) 0x0000)

// japanese hankaku katakana character
#define SJIS_KANA_CHARACTER ((unsigned int) 0x0100)

// Return special type field of C.
#define GetSpecialType(c) ((unsigned int) (c) & SJIS_SPECIAL_TYPE_MASK)

// Return character set of C.
#define GetCharacterSet(c) ((unsigned int) (c) & SJIS_CHARACTER_SET_MASK)

// Return True if C is kanji character.
#define IsKanji(c) ((short) (c) < 0)

// Return True if C is ansi character.
#define IsAnsi(c) (GetCharacterSet(c) == SJIS_ANSI_CHARACTER)

// Return True if C is japanese hankaku katakana.
#define IsKana(c) (GetCharacterSet(c) == SJIS_KANA_CHARACTER)

// Return True if C is panel.
#define IsPanel(c) (GetSpecialType(c) == SJIS_PANEL_SPECIAL)

// ------------------------------------------------------------
// character type(encoding type)

typedef enum
{
  CharType_UNKNOWN,
  CharType_ANSI,
  CharType_KANA,
  CharType_KANJI,
  CharType_PANEL,
  CharType_UNUSED_MAX,
} CharType;

extern CharType NEAR char_type_table[];

#define GET_CHAR_TYPE(ch) \
(char_type_table[(unsigned short) (ch) >> BITS_PER_CHAR])

#define USE_KANJI_FONT(ch) (0x100 <= ch)

inline sjis
MakeByteChar(int a, int char_set)
{
  return((sjis) (char_set | a));
}

inline sjis
MakeKanaChar(int a)
{
  return(MakeByteChar(a, SJIS_KANA_CHARACTER));
}

inline sjis
MakeAnsiChar(int a)
{
  return(MakeByteChar(a, SJIS_ANSI_CHARACTER));
}

inline sjis
MakeKanjiChar(int high, int low)
{
  return((high << BITS_PER_CHAR) | low);
}

inline sjis
MakeSpecialChar(int code, int special)
{
  return((sjis) (special | code));
}

inline sjis
MakePanelChar(int code)
{
  return(MakeSpecialChar(code, SJIS_PANEL_SPECIAL));
}

inline int
GetCharCode(sjis ch)
{
  return((sjis) (ch & SJIS_CHARACTER_CODE_MASK));
}

inline int
GetSpecialCode(sjis ch)
{
  return((sjis) (ch & SJIS_SPECIAL_CODE_MASK));
}

// ------------------------------------------------------------
// character class(semantic type)

// shift-jis code
#define SJIS_KANJI_BASE ((unsigned int) 0x889e)
#define SJIS_RUSSIAN_GREEK_BASE ((unsigned int) 0x839e)
#define SJIS_TABLE_BASE ((unsigned int) 0x8140)

#define SJIS_TABLE_END ((unsigned int) SJIS_RUSSIAN_GREEK_BASE)
#define SJIS_TABLE_SIZE ((unsigned int) (SJIS_TABLE_END - SJIS_TABLE_BASE))

// Do not use this enum's symbols directory.  Let's use inline functions
// defined below.
typedef enum
{
  CharClass_RANDOM_PUNCT = 0,	// normal punctuator
  CharClass_LEFT_PUNCT,		// left side punctuator
  CharClass_RIGHT_PUNCT,	// right side punctuator

  CharClass_NORMAL_SPACE,	// space, tab, ...
  CharClass_SPECIAL_SPACE,	// newline and end-of-buffer
  
  CharClass_DIGIT,		// decimal digit
  CharClass_EUROCHAR,		// alphabet, greek, ...

  CharClass_KANA,		// han-kaku katakana
  CharClass_RIGHT_KANA,		// han-kaku katakana(small)
  CharClass_HIRAGANA,		// zen-kaku hiragana
  CharClass_RIGHT_HIRAGANA,	// zen-kaku hiragana(small)
  CharClass_KATAKANA,		// zen-kaku katakana
  CharClass_RIGHT_KATAKANA,	// zen-kaku katakana(small)
  CharClass_KANJI,		// kanji
  CharClass_RIGHT_KANJI,	// kanji(repeat character)

  CharClass_SPECIAL,		// PANEL, ...

  CharClass_UNUSED_MAX,
} CharClass;

extern CharClass NEAR ansi_char_class_table[];
extern CharClass NEAR kana_char_class_table[];
extern CharClass NEAR sjis_char_class_table[];
extern char NEAR break_table[CharClass_UNUSED_MAX][CharClass_UNUSED_MAX];

inline bool
EndOfLineP(CharClass cc)
{
  return(cc == CharClass_SPECIAL_SPACE);
}

inline bool
WhiteSpaceP(CharClass cc)
{
  return(cc == CharClass_NORMAL_SPACE || cc == CharClass_SPECIAL_SPACE);
}

inline bool
DigitP(CharClass cc)
{
  return(cc == CharClass_DIGIT);
}

inline bool
SpecialP(CharClass cc)
{
  return(cc == CharClass_SPECIAL);
}

CharClass GetCharClass(sjis c);

#endif /* SJIS_H */

