// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: slist.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// single pointer list class

#include "pword.h"
#include "slist.h"

SingleListItem::SingleListItem(void* data, SingleListItem* next)
{
  SingleListItem::data = data;
  SingleListItem::next = next;
}

SingleList::SingleList()
{
  sentinel = first_item = new SingleListItem(0, 0);	// sentinel
}

SingleList::~SingleList()
{
  SingleListItem* item = first_item;
  while (item != sentinel) 
  {
    SingleListItem* del = item;
    item = item->next;
    delete del;
  }
  delete sentinel;
}


void 
SingleList::Push(void* data)
{
  first_item = new SingleListItem(data, first_item);
}

void* 
SingleList::Pop()
{
  if (first_item == sentinel) 
  {
    return 0;				// no entry
  }
  void* data = first_item->data;
  SingleListItem* del = first_item;
  first_item = first_item->next;
  delete del;
  return data;
}

void 
SingleList::Delete(void* data)
{
  sentinel->data = data;	// set sentinel data, for loop optimize.
  SingleListItem* item = first_item;
  while (item->data != data) 
  {
    item = item->next;
  }
  if (item != sentinel) 
  {
    // find entry
    SingleListItem* next = item->next;
    *item = *next;			// copy next item to here
    if (next == sentinel) 
    {		// item is last entry
      sentinel = item;
    }
    delete next;
  }
}

uword 
SingleList::Number()
{
  uword count = 0;
  for (SingleListItem* itm = first_item; itm != sentinel; itm = itm->next) 
  {
    count++;
  }
  return count;
}

void* 
SingleList::GetTopData()
{
  if (first_item == sentinel) 
  {
    // no enrty
    return 0;
  }
  return first_item->data;
}

uword 
SingleList::Search(void* data)
{
  SingleListItem* item = first_item;
  sentinel->data = data;		// for loop optimize
  uword pos = 1;
  while (item->data != data) 
  {
    item = item->next;
    pos++;
  }
  if (item != sentinel) 
  {
    // find data
    return pos;
  }
  return 0;				// can't find
}

void* 
SingleList::Eject()
{
  SingleListItem* item = first_item;
  SingleListItem* last = 0;
  while (item != sentinel) 
  {
    last = item;
    item = item->next;
  }
  if (last != 0) 
  {
    // find last data
    void* data = last->data;
    last->next = 0;
    delete sentinel;
    sentinel = last;
    return data;
  }
  // there is no item.
  return 0;
}

void 
SingleList::Inject(void* data)
{
  SingleListItem* item = sentinel;
  item->data = data;
  item->next = sentinel = new SingleListItem(0, 0);	// sentinel
}

void* 
SingleList::Access(uword n)
{
  uword count = 1;
  for (SingleListItem* itm = first_item; itm != sentinel; itm = itm->next) 
  {
    if (count++ == n) 
    {
      return itm->data;
    }
  }
  // error
  return 0;
}

void* 
SingleList::operator [] (uword n)
{
  return Access(n + 1);
}

void 
SingleList::Delete(uword n)
{
  uword count = 1;
  for (SingleListItem* itm = first_item;
       itm != sentinel;
       itm = itm->next) 
  {
    if (count++ == n) 
    {
      SingleListItem* next = itm->next;
      *itm = *next;
      if (next == sentinel) 
      {
	sentinel = itm;
      }
      delete next;
      break;
    }
  }
}

void 
SingleList::Replace(uword n, void* data)
{
  uword count = 1;
  for (SingleListItem* itm = first_item;
       itm != sentinel;
       itm = itm->next) 
  {
    if (count++ == n) 
    {
      itm->data = data;
      break;
    }
  }
}

void 
SingleList::Insert(uword n, void* data)
{
  if (n == 0) 
  {
    // insert in first position
    Push(data);
    return;
  }
  uword count = 1;
  for (SingleListItem* itm = first_item;
       itm != sentinel;
       itm = itm->next) 
  {
    if (count++ == n) 
    {
      itm->next = new SingleListItem(data, itm->next);
      break;
    }
  }
}

void 
SingleList::Insert(void* prev, void* data)
{
  if (prev == 0) 
  {
    // insert in first position
    Push(data);
    return;
  }
  sentinel->data = prev;	// set sentinel data, for loop optimize.
  SingleListItem* item = first_item;
  while (item->data != prev) 
  {
    item = item->next;
  }
  if (item != sentinel) 
  {
    // find
    item->next = new SingleListItem(data, item->next);
  }
}

void 
SingleList::Clear()
{
  SingleListItem* item = first_item;
  while (item != sentinel) 
  {
    SingleListItem* del = item;
    item = item->next;
    delete del;
  }
  first_item = sentinel;
}

SingleListIterator::SingleListIterator(SingleList* slist)
{
  SingleListIterator::slist = slist;
  current = 0;
}

SingleListIterator::SingleListIterator(SingleList& slist)
{
  SingleListIterator::slist = &slist;
  current = 0;
}

void 
SingleListIterator::Revert()
{
  current = 0;
}

void* 
SingleListIterator::operator() ()
{
  if (IsEnd()) 
  {
    return 0;				// iterate after the end of iteration
  }
  if (current != 0) 
  {
    current = current->next;		// updata current
  }
  else 
  {				// first iteration
    current = slist->first_item;
  }
  // get data
  if (current != slist->sentinel) 
  {
    return current->data;
  }
  return 0;				// end of iteration
}


#if 0
// sample source
#include <stdio.h>
main()
{
  SingleList sl;
  int a = 1, b = 2, c = 3, d = 4, e = 5, f = 6;
  // --- Push test ---
  sl.Push(&a);
  sl.Push(&b);
  sl.Push(&c);
  sl.Push(&d);
  sl.Push(&e);
  sl.Push(&f);
  SingleListIterator sli(sl);
  void* data;
  while ((data = sli()) != 0) 
  {
    printf("%p %d\n", data, * ((int*)data));
  }
  printf("\n");
  // --- Delete test ---
  sl.Delete(&d);
  sli.Revert();
  while ((data = sli()) != 0) 
  {
    printf("%p %d\n", data, * ((int*)data));
  }
  printf("\n");
  
  // --- Push test ---
  sl.Push(&d);
  sli.Revert();
  while ((data = sli()) != 0) 
  {
    printf("%p %d\n", data, * ((int*)data));
  }
  printf("\n");
  
  // --- Search test ---
  uword pos;
  if ((pos = sl.Search(&a)) != 0) 
  {	// a search
    printf("find %d\n", pos);
  }
  else 
  {
    printf("may be wrong implementaion!\n");
  }
  if ((pos = sl.Search(0)) != 0) 
  {	// 0 search
    printf("find %d, ", pos);		// may be wrong implementation!
    printf("may be wrong implementaion!\n");
  }
  else 
  {
    printf("can't find\n");
  }
  
  if ((sl.Search(&sl)) != 0) 
  {		// sl search
    printf("find %d, ", pos);		// may be wrong implementaion!
    printf("may be wrong implementaion!\n");
  }
  else 
  {
    printf("can't find\n");
  }
  
  // --- Number test ---
  uword n = sl.Number();
  printf("Number is %d\n", n);
  
  // -- GetTopData test ---
  printf("GetTopData %p\n", sl.GetTopData());
  
  // --- LastPush test ---
  printf("LastPush test\n");
  int j = 100;
  sl.LastPush(&j);
  sli.Revert();
  while ((data = sli()) != 0) 
  {
    printf("%p %d\n", data, * ((int*)data));
  }
  printf("\n");
  
  // --- FifoPop test ---
  printf("FifoPop:%p \n", sl.FifoPop());
  sli.Revert();
  while ((data = sli()) != 0) 
  {
    printf("%p %d\n", data, * ((int*)data));
  }
  printf("\n");
  
  // --- pop test ---
  for (uword i = 0; i < n; i++) 
  {
    printf("Pop %p\n", sl.Pop());
  }
  printf("\n");
}
#endif
