// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: slist.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// single pointer list class

#ifndef SLIST_H
#define SLIET_H

class SingleListItem;			// forword ref.

// single list representation
class SingleList 
{
  friend class SingleListIterator;
  
  // first single-list item
  SingleListItem* first_item;
  
  // end of, dummy data
  SingleListItem* sentinel;
  
public:
  // constructor
  SingleList();
  
  // destructor
  ~SingleList();
  
#define LIST_METHODS   
#include "commlist.h"   
#undef LIST_METHODS
  
};

// single list data representation
class SingleListItem 
{
  friend class SingleList;
  friend class SingleListIterator;
  
  // data
  void* data;
  
  // next pointer
  SingleListItem* next;
  
  // constructor
  // this constructor is used only by class slist
  SingleListItem(void* data, SingleListItem* next);
};

// single list iterator
class SingleListIterator 
{
  // single list
  SingleList* slist;
  
  // current data
  SingleListItem* current;
  
public:
  // constructor
  SingleListIterator(SingleList* slist);
  
  // constructor
  SingleListIterator(SingleList& slist);
  
#define LISTITERATOR_METHODS
#include "commlist.h"
#undef LISTITERATOR_METHODS
  
  // get current item
  SingleListItem* GetCurrentItem() 
  {
    return current;
  }
};

inline bool 
SingleListIterator::IsEnd() 
{ 
  return(current == slist->sentinel); 
}

#endif /* SLIST_H */
