// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: smartnew.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// replacement of new and delete

#ifndef SMARTNEW_H
#define SMARTNEW_H

#ifndef NDEBUG
#define NEW_SIZE size
#else
#define NEW_SIZE
#endif

#define SMARTNEW_CHAIN(p, class) (*(class **) (p))

#define REFER_SMARTNEW(class) \
static class* smart_free_list; \
void* CDECL operator new(size_t NEW_SIZE); \
void CDECL operator delete(void* mem); \

#define DEFINE_SMARTNEW(class)						\
									\
class* class::smart_free_list = NULL;					\
									\
void* CDECL								\
class::operator new(size_t NEW_SIZE)					\
{									\
  assert(NEW_SIZE == sizeof(class));					\
  class* p = class::smart_free_list;					\
  if (p == NULL)							\
  {									\
    p = (class*) xmalloc_permanent(sizeof(class));			\
  }									\
  else									\
  {									\
    class::smart_free_list = SMARTNEW_CHAIN(p, class);			\
  }									\
  return(p);								\
}									\
									\
void CDECL								\
class::operator delete(void* mem)					\
{									\
  if (mem)								\
  {									\
    SMARTNEW_CHAIN(mem, class) = class::smart_free_list;		\
    class::smart_free_list = (class*) mem;				\
  }									\
}									\

#endif /* SMARTNEW_H */
