// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: styles.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// manage style table

#include "pword.h"
#include "styles.h"
#include "attribut.h"
#include "atts.h"
#include "derivs.h"
#include "menu.h"
#include "pmenus.h"
#include "pstreams.h"
#include "xstr.h"

#define T StyleEntry
#define TABLE BaseStyleTable
#define SEG BaseStyleTableSeg
#define DO_READ_WRITE
#include "tabletem.cpp"

StyleTable STATIC_NEAR GlobalStyleTable;

// public method
unsigned int
StyleTable::FindEntry(char* name, int type, int include_dead)
{
  unsigned int limit = this->GetNEntries();
  unsigned int a = 0;
  while (++a != limit)
  {
    StyleEntry& e = ::get_style_entry(a);
    if (e.type == type
	&& (include_dead || !e.dead) && strcmp(e.name, name) == 0)
    {
      return(a);
    }
  }
  return(0);
}

// private method
void NEAR
StyleEntry::Init()
{
  this->at_index = 0;
  this->name[0] = '\0';
  this->type = 0;
  this->count = 0;
  this->dead = 0;
};

// public constructor
StyleEntry::StyleEntry()
{
  this->Init();
}

// public constructor
StyleEntry::StyleEntry(char* name, int type)
{
  this->Init();
  this->type = type;
  copy_string(this->name, name, NAMELEN + 1);
}

// private method
unsigned char NEAR
StyleEntry::GetHash()
{
  unsigned char x = (unsigned char) this->type;
  unsigned char* s = (unsigned char*) this->name;
  unsigned char c;
  while ((c = *s++) != '\0')
  {
    x = x ^ (x << 3) ^ c;
  }
  return(x);
}

int
operator == (StyleEntry& e1, StyleEntry& e2)
{
  return((e1.dead | e2.dead) == 0
	   && e1.type == e2.type
	   && e1.at_index == e2.at_index && strcmp(e1.name, e2.name) == 0);
}

void
StyleEntry::Mark()
{
  if (!this->GetMark())
  {
    this->SetMark();
    int at_index = this->at_index;
    if (VALID_ATTR_INDEX_P(at_index))
    {
      ::get_atts_entry(at_index) .Mark();
    }
  }
}

AttsEntry&
StyleEntry::GetAttsEntry()
{
  return(::get_atts_entry(at_index));
}

unsigned int StyleEntry::Enter()
{
  return GlobalStyleTable.MakeEntry(*this);
}

void
StyleEntry::AddToInterface(unsigned int i, void*)
{
  unsigned int first_index = GlobalStyleTable.FindEntry(this->name,
							 this->type, True);
  int count = this->count;
  if (count == 0)
  {
    StyleEntry& first = ::get_style_entry(first_index);
    count = first.count + 1;
    first.count = count;
    this->count = count;
  }
  char buf[NAMELEN + 10];
  strcpy(buf, this->name);
  if (first_index != i)
  {
    wsprintf(strchr(buf, '\0'), " (%d)", count);
  }

  Menu_Type menu_type = Menu_Type_UNUSED_MAX;
  switch (this->type)
  {
   case AttsEntry::CHARSTYLE:
    menu_type = Menu_Type_CHAR_STYLE;
    break;
    
   case AttsEntry::PARSTYLE:
    menu_type = Menu_Type_PARA_STYLE;
    break;
  }
  if (menu_type != Menu_Type_UNUSED_MAX)
  {
    Menu::add_menu(menu_type, i, buf);
  }
}

void
StyleEntry::RemoveFromInterface(unsigned int i)
{
  Menu_Type menu_type = Menu_Type_UNUSED_MAX;
  switch (this->type)
  {
   case AttsEntry::CHARSTYLE:
    menu_type = Menu_Type_CHAR_STYLE;
    break;
    
   case AttsEntry::PARSTYLE:
    menu_type = Menu_Type_PARA_STYLE;
    break;
  }
  if (menu_type != Menu_Type_UNUSED_MAX)
  {
    Menu::delete_menu(menu_type, i);
  }
}

void
StyleEntry::WriteToStream(PStream* stream)
{
  stream->StartBlockOut(PStream::HDR_STYLEENTRY);
  CHECK;
  
  stream->OutString(name);
  CHECK;
  
  GlobalAttsTable.WriteEntry(stream, at_index);
  CHECK;
  
  stream->OutUWord(type);
  CHECK;
  
  stream->EndBlockOut(); CHECK;
}

void
StyleEntry::ReadFromStream(PStream* stream)
{
  word vers;
  stream->StartTypedBlockIn(PStream::HDR_STYLEENTRY, vers);
  CHECK;
  
  char* s = stream->InString();
  CHECK;
  copy_string(name, s, NAMELEN+1);
  delete s;
  
  at_index = GlobalAttsTable.ReadEntry(stream);
  type = stream->InUWord(); CHECK;
  
  stream->EndBlockIn();
}

void
StyleTable::Kill(uword i)
{
  StyleEntry& e = ::get_style_entry(i);
  if (e.dead == 0)
  {
    e.dead = 1;
    e.RemoveFromInterface(i);
  }
}

void
StyleTable::Resurrect(uword i)
{
  StyleEntry& e = ::get_style_entry(i);
  if (e.dead != 0)
  {
    e.dead = 0;
    e.AddToInterface(i, 0);
  }
}

// static method
void
StyleTable::register_static_menus()
{
  Menu::add_static_menu(Menu_Type_CHAR_STYLE,
			 0, S_none_style_name, IDM_More_NoCharStyle);
  Menu::add_static_menu(Menu_Type_PARA_STYLE,
			 0, S_none_style_name, IDM_More_NoParaStyle);
}

#ifndef NDEBUG
void
StyleEntry::DumpHeader(FILE* f)
{
  fprintf(f, 
	   "\nStyle Table\n\n"
	   "NNNN T ATI  Name\n"
	 );
}

void
StyleEntry::Dump(unsigned int i, void* v)
{
  FILE* f = (FILE*) v;
  fprintf(f, "%4d %1d %4d %s\n", i, type, at_index, name);
}
#endif
