// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: tablepnl.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class TablePanel
// 璭߂\\NXBPanel pĂA
// Table NXƑ݂ɎQƂĂB

#include "pword.h"
#include "tflist.h"
#include "rect.h"
#include "tablepnl.h"
#include "table.h"
#include "textflow.h"
#include "frametem.h"
#include "frameins.h"
#include "layoutte.h"
#include "layoutin.h"
#include "uniqltl.h"
#include "fission.h"
#include "borderli.h"
#include "pstreams.h"
#include "docconte.h"
#ifndef NDEBUG
#include "ddisplay.h"
#endif

// ------------------------------------------------------------
// feature inline functions here!

Table* 
TablePanel::GetTable()
{
  return table;
}

// get panel id
Panel::PanelID TablePanel::GetPanelID()
{
  return TablePanelID;
}

// constructor
TablePanel::TablePanel(DocumentContent* doc, BufferPointer* bpp, 
			Iunit width, Iunit height, uword column, uword row)
  : Panel(doc, bpp, width, height)
{
  // this line is very important
  // because, this pointer is referenced in the table constructor.
  table = 0;
  
  table = new Table(doc, width, height, column, row);
  table->SetPanel(this);
  InsertPanel();
}

// constructor for null table
TablePanel::TablePanel(DocumentContent* doc, BufferPointer* bpp, 
			Iunit width, Iunit height)
  : Panel(doc, bpp, width, height)
{
  table = 0;
  table = new Table(doc, width, height, 0, 0);
  table->SetPanel(this);
  InsertPanel();
}

// constructor as a picture
TablePanel::TablePanel(DocumentContent* doc, BufferPointer* bpp, 
			Iunit width, Iunit height, Picture* pic)
  : Panel(doc, bpp, width, height)
{
  table = 0;
  table = new Table(doc, width, height, pic);
  table->SetPanel(this);
}

// constructor for metafile
TablePanel::TablePanel(DocumentContent* doc, BufferPointer* bpp, 
			Iunit width, Iunit height, Metafile* mf)
  : Panel(doc, bpp, width, height)
{
  table = 0;
  table = new Table(doc, width, height, mf);
  table->SetPanel(this);
}

// constructor for file read
TablePanel::TablePanel(DocumentContent* doc, BufferPointer* bpp,
			LayoutTemplate* lt, Table* table)
  : Panel(doc, bpp, lt->GetWidth(), lt->GetHeight())
{
  TablePanel::table = table;
}

// destructor
TablePanel::~TablePanel()
{
  delete table;
}

// get additional width
Iunit 
TablePanel::GetAdditionalWidth()
{
  FissionFrame* ff = table->GetLayoutTemplate()->GetFissionFrame();
  uword l_index = ff->GetLeft()->GetStartCrossPoint()->GetVBorder();
  uword r_index = ff->GetRight()->GetStartCrossPoint()->GetVBorder();
  return BorderLine::GetLeftWidth(l_index) +
  BorderLine::GetRightWidth(r_index);
}

// get additional height
Iunit 
TablePanel::GetAdditionalHeight()
{
  FissionFrame* ff = table->GetLayoutTemplate()->GetFissionFrame();
  uword t_index = ff->GetTop()->GetStartCrossPoint()->GetHBorder();
  uword b_index = ff->GetBottom()->GetStartCrossPoint()->GetHBorder();
  return BorderLine::GetUpperWidth(t_index) +
  BorderLine::GetLowerWidth(b_index);
}

// get layout offset
Vector 
TablePanel::GetLayoutOffset()
{
  FissionFrame* ff = table->GetLayoutTemplate()->GetFissionFrame();
  uword l_index = ff->GetLeft()->GetStartCrossPoint()->GetVBorder();
  uword t_index = ff->GetTop()->GetStartCrossPoint()->GetHBorder();
  return Vector(BorderLine::GetLeftWidth(l_index), 
                 BorderLine::GetUpperWidth(t_index));
}

// change panel size
void 
TablePanel::ChangeSize(Iunit width, Iunit height)
{
  Panel::ChangeSize(width, height);
  table->ChangeSize(width, height);
}

// change panel size with no scalling
void 
TablePanel::StretchSize(Iunit top_diff, Iunit bot_diff,
			 Iunit lef_diff, Iunit rig_diff)
{
  Panel::StretchSize(top_diff, bot_diff, lef_diff, rig_diff);
  table->StretchSize(top_diff, bot_diff, lef_diff, rig_diff);
}

// update panel position
void 
TablePanel::SetPanelPosition(Lunit pos_x, Lunit pos_y)
{
  Vector offset = GetLayoutOffset();
  Panel::SetPanelPosition(pos_x, pos_y);
  table->SetPosition(pos_x + offset.x, pos_y + offset.y);
}

// save
void 
TablePanel::WriteToStream(PStream* stream)
{
  // write panel header
  Panel::WriteHeaderToStream(stream);
  CHECK;
  
  // write table-panel header
  int header = PStream::HDR_TABLEPANEL;
  stream->OutUWord(header);
  CHECK;
  
  // save text-flow number
  PageMap* pm = table;
  uword gate_num = pm->GetGateSize();
  stream->OutUWord(gate_num);
  CHECK;
  
  // save template
  UniqLTList ltlist;
  LayoutTemplate* lt = pm->GetLayoutTemplate();
  ltlist.Add(lt);
  lt->WriteToStream(stream);
  CHECK;
  
  // save page-map
  pm->WriteToStream(stream, &ltlist);
  CHECK;
  
  // save text-flow
  TFListIterator tfli(pm->GetTFMap());
  TextFlow* tf;
  while ((tf = tfli()) != 0) 
  {
    tf->WriteFormattedToStream(stream);
    CHECK;
  }
}

// ascii save
void 
TablePanel::WriteASCIIToStream(BufStream* stream)
{
  PageMap* pm = table;
  TFListIterator tfli(pm->GetTFMap());
  TextFlow* tf;
  while ((tf = tfli()) != 0) 
  {
    if (tf != 0) 
    {
      tf->WriteASCIIToStream(stream);
      stream->NewLine();
      CHECK;
    }
  }
}

// load
Panel* 
TablePanel::ReadFromStream(DocumentContent* doc, 
			    BufferPointer* bpp, 
			    PStream* stream)
{
  // read header
  int header = stream->InUWord();
  CHECK 0;
  
  if (header != PStream::HDR_TABLEPANEL) 
  {
    // header error
    return 0;
  }
  
  // read text-flow number
  uword flow_num =  stream->InUWord();
  CHECK 0;
  
  TFList tflist;
  for (uword n = 1; n <= flow_num; n++) 
  {
    // create text-flow
    tflist.Inject(new TextFlow(doc));
  }
  
  // read template
  LayoutTemplate* lt = LayoutTemplate::ReadFromStream(stream, doc);
  CHECK 0;
  UniqLTList ltlist;
  ltlist.Add(lt);
  
  // read table
  Table* pm = new Table(lt);
  
  PageMap::ReadFromStream(pm, stream, doc, &ltlist, &tflist);
  CHECK 0;
  
  // read text-flow
  TFListIterator tfli(pm->GetTFMap());
  TextFlow* tf;
  while ((tf = tfli()) != 0) 
  {
    if (tf != 0) 
    {
      tf->ReadFormattedFromStream(stream);
      CHECK 0;
    }
  }
  
  TablePanel* tp = new TablePanel(doc, bpp, lt, (Table*)pm);
  pm->SetPanel(tp);
  
  // make table layout
  LayoutInstance* li = pm->GeneratePage();
  tp->table->SetLayout(li);
  
  return tp;
}

void 
TablePanel::Mark(PStream* stream)
{
  PageMap* pm = table;
  TFListIterator tfli(pm->GetTFMap());
  TextFlow* tf;
  while ((tf = tfli()) != 0) 
  {
    if (tf != 0) 
    {
      tf->MarkCookieConnections(stream);
    }
  }
}

// get layout
LayoutInstance* 
TablePanel::GetLayout()
{
  return(table != 0) ? table->GetLayout() : 0;
}

// get max and min
Iunit 
TablePanel::GetMaxTableSize()
{
  return PageSize::GetMaxPaperSize();
}

Iunit 
TablePanel::GetMinTableSize()
{
  return PageSize::GetMinRegularSize();
}

// get default table size
Iunit 
TablePanel::GetDefaultTableSize()
{
  return PageSize::GetMinPaperSize();
}

bool 
TablePanel::ConfirmReadAll()
{
  return table->GetLayoutTemplate()->ConfirmReadAll();
}
