// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: tablepnl.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class TablePanel
// 璭߂\\NXBPanel pĂA
// Table NXƑ݂ɎQƂĂB

#ifndef TABLEPNL_H
#define TABLEPNL_H

#include "panel.h"
class Table;
class Picture;
class Metafile;

class TablePanel
  : public Panel
{
private:
  // which table
  Table* table;
  
private:
  // get panel id
  PanelID GetPanelID();
  
  // register itself at flow
  void RegisterPanel();
  
protected:
  // get additional width
  Iunit GetAdditionalWidth();
  
  // get additional height
  Iunit GetAdditionalHeight();
  
  // get layout offset
  Vector GetLayoutOffset();
  
public:
  // constructor as ordinary table
  TablePanel(DocumentContent* doc, BufferPointer* bpp, 
              Iunit width, Iunit height, uword column, uword row);
  
  // constructor for null table
  TablePanel(DocumentContent* doc, BufferPointer* bpp, 
              Iunit width, Iunit height);
  
  // constructor for picture
  TablePanel(DocumentContent* doc, BufferPointer* bpp, 
              Iunit width, Iunit height, Picture* pic);
  
  // constructor for metafile
  TablePanel(DocumentContent* doc, BufferPointer* bpp,
              Iunit width, Iunit height, Metafile* mf);
  
  // constructor for file read
  TablePanel(DocumentContent* doc, BufferPointer* bpp, 
              LayoutTemplate* lt, Table* tb);
  
  // destructor
  ~TablePanel();
  
  // change panel size with scalling
  void ChangeSize(Iunit width, Iunit height);
  
  // change panel size with no scalling
  void StretchSize(Iunit top_diff, Iunit bot_diff,
                    Iunit lef_diff, Iunit rig_diff);
  
  // get table
  Table* GetTable();
  
  // update panel position
  // this method is virtual function.
  void SetPanelPosition(Lunit pos_x, Lunit pos_y);
  
  // load
  static Panel* ReadFromStream(DocumentContent* doc, 
				BufferPointer* bpp, PStream* ps);
  
  // save
  void WriteToStream(PStream* ps);
  
  // ascii save
  void WriteASCIIToStream(BufStream* ps);
  
  // mark attribute
  void Mark(PStream* ps);
  
  // get layout
  LayoutInstance* GetLayout();
  
  // get max and min
  static Iunit GetMaxTableSize();
  static Iunit GetMinTableSize();
  
  // get default table size
  static Iunit GetDefaultTableSize();
  
  // read check
  bool ConfirmReadAll();
};

#endif /* TABLEPNL_H */
