// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: textflow.cpp,v 3.4 1999/05/12 00:22:16 kudou Exp $
// implement TextFlow class for handling text flows

#include "pword.h"
#include "marks.h"
#include "attribut.h"
#include "bufnew.h"
#include "interval.h"
#include "layoutte.h"
#include "layoutin.h"
#include "frametem.h"
#include "frameins.h"
#include "statdlg.h"
#include "document.h"
#include "docwindo.h"
#include "docconte.h"
#include "docprese.h"
#include "docedit.h"
#include "docsel.h"
#include "pundo.h"
#include "line.h"
#include "pstreams.h"
#include "textflow.h"
#ifndef NDEBUG
#include "ddisplay.h"
#endif

// stream version
const int TextFlow::textflow_vers = 1;

void
TextFlow::SetFirstDirtyID(Paragraph* p)
{
  if (p == NULL
      || this->first_dirty_id == 0
      || (p->GetCmpValue() < this->first_dirty_id->GetCmpValue()))
  {
    this->first_dirty_id = p;
  }
}

Paragraph* 
TextFlow::SeedParagraph()
{
  return(Paragraph::MakeInstance(this,
				   NULL, ::get_default_attributes(NULL)));
}

BP* 
TextFlow::GetStartBufferPointer() 
{ 
  return(this->first_paragraph->GetStartBufferPointer());
}

BP* 
TextFlow::GetEndBufferPointer()
{ 
  return(this->last_paragraph->GetEndBufferPointer());
}

TextFlow::TextFlow(DocumentContent* doc)
{
  this->next = NULL;		// This value is set by DocumentContent.
  this->prev = NULL;		// This value is set by DocumentContent.
  this->first_paragraph = 0;
  this->last_paragraph = 0;
  this->serial = 0;
  this->first_dirty_id = 0;
  this->first_frame = 0;
  this->format_needed_p = True;
  this->on_zero_page_p = False;
  this->on_table_p = False;
  this->on_flags_is_initialized_p = False;
  this->overflowp = False;
  this->set_tategaki_flow_p(False);
  this->formatted_frame = NULL;
  this->docconte = doc;
  doc->AddTextFlow(this);
}

// destructor
TextFlow::~TextFlow()
{
  docconte->RemoveTextFlow(this);
  Paragraph* ph = first_paragraph;
  while (ph)
  {
     Paragraph* next = ph->GetNextParagraph();
     delete ph;
     ph = next;
  }
}

FrameInstance*
TextFlow::GetFirstFrame()
{
  if (first_frame == 0)
  {
    first_frame = docconte->GetFirstTextFlowFrame(this);
  }
  return first_frame;
}

void
TextFlow::ReportDeadFrame(FrameInstance* fi)
{
  if (fi == first_frame)
  {
    first_frame = 0;
  }
}

Paragraph*
TextFlow::FindParagraph(long find_id)
{
  for (Paragraph* p=GetFirstParagraph(); p; p=p->GetNextParagraph())
  {
    if ((udword)find_id == p->GetID())
    {
      return p;
    }
  }
  return 0;
}

// file-related

void
TextFlow::MarkCookieConnections(PStream* stream)
{
  for (Buffer* b = this->first_paragraph; b; b = b->GetNext())
  {
    b->MarkCookieConnections(stream,
			      b->GetBeginningOffset(), b->GetEndOffset());
  }
}

// TextFlow::WriteFormattedToStream writes itself to the stream
void
TextFlow::WriteFormattedToStream(PStream* stream)
{
  Buffer* b;
  unsigned long count = 0;
  
  for (b = this->first_paragraph; b; b = b->GetNext())
  {
    ++count;
  }
  
  stream->StartBlockOut(PStream::HDR_TEXTFLOW, textflow_vers);
  CHECK;
  
  stream->OutULong(serial);
  CHECK;
  
  stream->OutULong(count);
  CHECK;
  
  for (b = this->first_paragraph; b; b = b->GetNext())
  {
    // textflows always write out everything about themselves.
    b->WriteFormattedToStream(stream,
			       b->GetBeginningOffset(), b->GetEndOffset());
    CHECK;
  }

  // BW2_FILE_FORMAT
  // New information on V1.1 or later.
  stream->OutByte(this->tategaki_flow_p() ? 1 : 0);
  CHECK;
  
  stream->EndBlockOut();
  // skip last CHECK
}

void
TextFlow::ReadFormattedFromStream(PStream* stream)
{
  word vers;
  Paragraph* p,* prev=NULL;

  // read and check header
		
  stream->StartTypedBlockIn(PStream::HDR_TEXTFLOW, vers);
  CHECK;
  
  if (vers >= 1)
  {
    serial = stream->InULong();
  }
  
  unsigned long count = stream->InULong();
  CHECK;
  
  BufferPointer* where;
  
  // read each paragraph
  
  while (count--)
  {
    // make a new paragraph and have it read itself
			
    p = Paragraph::MakeInstance(this, prev, 0);
    where = p->GetStartBufferPointer();
    p->ReadFormattedFromStream(stream, where);
    delete where;
    CHECK;
    prev = p;
  }

  // BW2_FILE_FORMAT
  // New information on V1.1 or later.
  int tategakip = (int) stream->InByte();
  switch (stream->GetError())
  {
   default:
    return;
    
   case SE_NOMORE:
    stream->SetError(SE_NOERROR);
    break;

   case SE_NOERROR:
    if (tategakip)
    {
      this->set_tategaki_flow_p(True);
    }
    break;
  }
  
  stream->EndBlockIn();
  // skip last CHECK
}

// reading and writing ASCII textflows to and from streams
void
TextFlow::WriteASCIIToStream(BufStream* stream)
{
  bool first = True;
  for (Buffer* b = this->first_paragraph; b; b = b->GetNext(), first = False)
  {
    if (!first)
    {
      stream->NewLine();
      CHECK;
    }
    b->WriteASCIIToStream(stream,
			   b->GetBeginningOffset(), b->GetEndOffset());
    CHECK;  
  }
}

void
TextFlow::Count(Stats& stats)
{
  Line* l = this->GetFirstFrame()->GetLines();
  while (!(l=l->XGetNext())->NilP())
  {
    stats.line++;
  }
  
  for (Paragraph* p = GetFirstParagraph(); p; p=p->GetNextParagraph())
  {
    p->Count(stats);
    stats.par++;
  }
}

void
TextFlow::PrepareToDie(BufferPointer* bp)
{
  DocumentContent* conte = this->GetDocContent();
  conte->GetUndo() ->ReportDeadTextFlow(this);
  
  // clean up or eliminate affected marks
  GlobalMarkTable.ReportDeadTextFlow(this);
  
  for (DocumentWindow* w = conte->GetFirstDocWindow();
       w; w = w->GetNextDocWindow())
  {
    // clean up selections
    w->GetEditor() ->GetSelectionStack() ->ReportDeadTextFlow(this, bp);
  }
}

bool
TextFlow::IsEmpty()
{
  BufferPointer* start_bp = GetStartBufferPointer();
  BufferPointer* end_bp   = GetEndBufferPointer();
  bool ret = (bool)((*start_bp == *end_bp) != 0);
  delete start_bp;
  delete end_bp;
  return ret;
}
