// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: textflow.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// A TextFlow(Myers Idea) is a sequence of text targeted to a 
// sequence of FrameInstances.  It is basically one running script in
// a family of parallel or sequential running scripts, e.g., one
// language in a parallel text, one commentary in a talmudization,
// the "body", its "footnotes", etc.

#ifndef TEXTFLOW_H
#define TEXTFLOW_H

class TextFlow
{
private:
  // stream version
  static const int textflow_vers;
  
private:
  // back pointer
  DocumentContent* docconte;
  
  // point to character formatted completely
  FrameInstance* formatted_frame;
  
  // text flow list managing pointer
  TextFlow* next;
  TextFlow* prev;
  
  Paragraph* first_paragraph;
  Paragraph* last_paragraph;
  
  // some flags
  int format_needed_p : 1;
  int on_zero_page_p : 1;
  int on_table_p : 1;
  int on_flags_is_initialized_p : 1;
  int overflowp : 1;
  int tategaki_flow_p_ : 1;
  
  // id -- used only when reading in textflow
  long serial;
  
  // first bad numbered paragraph
  Paragraph* first_dirty_id;
  
  // first frame
  FrameInstance* first_frame;
  
public:
  TextFlow(DocumentContent* doc);
  ~TextFlow();
  
private:
  void NEAR Format0(bool one_step_p);
  
public:
  BufferPointer* GetBeginningBPCreate();
  BufferPointer* GetEndBPCreate();
  BufferPointer* GetEndBufferPointer();
  BufferPointer* GetStartBufferPointer();
  DocumentContent* GetDocContent();
  FrameInstance* GetFirstFrame();
  FrameInstance* GetFormattedFrame();
  FrameInstance* GetMaybeBrokenFrame();
  IntervalList* FindText(sjis* what, bool reverse, BufferPointer* , bool all);
  IntervalList* FindText(sjis*);
  IntervalList* FindText(sjis* , bool, BufferPointer*);
  Paragraph* FindParagraph(long);
  Paragraph* GetFirstDirtyID();
  Paragraph* GetFirstParagraph();
  Paragraph* GetLastParagraph();
  Paragraph* SeedParagraph();
  Paragraph** GetFirstParagraphPtr();
  Paragraph** GetLastParagraphPtr();
  TextFlow* GetNext();
  TextFlow* GetPrev();
  bool GetFormatNeededP();
  bool IsEmpty();
  bool OnTableP();
  bool OnZeroPageP();
  bool OverflowP();
  int TextFlow::get_index_x();
  bool TextFlow::tategaki_flow_p();
  udword GetSerial();
  void Count(Stats& stats);
  void DelayFormat();
  void DelayFormat(BufferPointer* bp0, BufferPointer* bp1);
  void Format();
  void FormatOneStep();
  void FormatNeeded();
  void InitializeOnFlags();
  void InsertFromStream(PStream* , BufferPointer* where);
  void MarkCookieConnections(PStream*);
  void PrepareToDie(BufferPointer*);
  void ReadFormattedFromStream(PStream*);
  void ReportChangeFirstFrame();
  void ReportDeadFrame(FrameInstance* fi);
  void Select(DocumentWindow*);
  void SetFirstDirtyID(Paragraph*);
  void SetFirstParagraph(Paragraph* para);
  void SetFormattedFrame(FrameInstance* frame);
  void SetLastParagraph(Paragraph* para);
  void SetNext(TextFlow* tf);
  void SetOverflowP(bool overflowp);
  void SetPrev(TextFlow* tf);
  void SetSerial(udword n);
  void TextFlow::set_tategaki_flow_p(int tategaki_flow_p);
  void WriteASCIIToStream(BufStream*);
  void WriteFormattedToStream(PStream*);
};

// get document content
inline DocumentContent* 
TextFlow::GetDocContent()
{
  return(this->docconte);
}

// get prev text-flow
inline TextFlow* 
TextFlow::GetPrev()
{
  return(this->prev);
}

// set prev text-flow
inline void
TextFlow::SetPrev(TextFlow* prev)
{
  this->prev = prev;
}

// get next text-flow
inline TextFlow* 
TextFlow::GetNext()
{
  return(this->next);
}

// set next text-flow
inline void
TextFlow::SetNext(TextFlow* next)
{
  this->next = next;
}

inline Paragraph**
TextFlow::GetFirstParagraphPtr()
{
  return(&this->first_paragraph);
}

// get first paragraph
inline Paragraph* 
TextFlow::GetFirstParagraph()
{
  return(this->first_paragraph);
}

inline void
TextFlow::SetFirstParagraph(Paragraph* para)
{
  this->first_paragraph = para;
}

inline Paragraph**
TextFlow::GetLastParagraphPtr()
{
  return(&this->last_paragraph);
}

// get last paragraph
inline Paragraph* 
TextFlow::GetLastParagraph()
{
  return(this->last_paragraph);
}

inline void
TextFlow::SetLastParagraph(Paragraph* para)
{
  this->last_paragraph = para;
}

// new name method
inline BufferPointer* 
TextFlow::GetBeginningBPCreate()
{
  return(this->GetStartBufferPointer());
}

// new name method
inline BufferPointer* 
TextFlow::GetEndBPCreate()
{
  return(this->GetEndBufferPointer());
}

inline bool
TextFlow::GetFormatNeededP()
{
  return format_needed_p != 0;
}

inline FrameInstance* 
TextFlow::GetFormattedFrame()
{
  return(this->formatted_frame);
}

inline void
TextFlow::SetFormattedFrame(FrameInstance* frame)
{
  this->formatted_frame = frame;
}

inline bool
TextFlow::OverflowP()
{
  return overflowp != 0;
}

inline void
TextFlow::SetOverflowP(bool overflowp)
{
  this->overflowp = overflowp;
}

inline udword
TextFlow::GetSerial()
{
  return(this->serial);
}

inline void
TextFlow::SetSerial(udword n)
{
  this->serial = n;
}

inline Paragraph* 
TextFlow::GetFirstDirtyID()
{
  return(this->first_dirty_id);
}

inline void
TextFlow::ReportChangeFirstFrame()
{
  this->first_frame = NULL;
}

inline bool
TextFlow::tategaki_flow_p()
{
  return (bool)(this->tategaki_flow_p_ != 0);
}

inline void
TextFlow::set_tategaki_flow_p(int tategaki_flow_p)
{
  this->tategaki_flow_p_ = tategaki_flow_p;
}

inline int
TextFlow::get_index_x()
{
  return(this->tategaki_flow_p_ ? INDEX_Y : INDEX_X);
}

#endif /* TEXTFLOW_H */
