// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: textindl.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implementation of TextInDialog class for dialog boxes
// where you say whether you want a file opened as Beatword or text.
// Another class, TextFormDialog, asks what style of text.

#include "pword.h"
#include "dialogs.h"
#include "pmenus.h"
#include "textindl.h"

TextInDialog::TextInDialog(char* _msg)
  : msg(_msg)
{
  this->class_name = "TextIn";
}

LRESULT_T
TextInDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    SetItemText(IDD_TextConvert_Message, msg);
    set_item_check(IDD_TextConvert_AsBW);
    return 1;
    
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDOK:
      if (get_item_check(IDD_TextConvert_AsTextFile))
      {
	End(IDD_TextConvert_AsTextFile);
      }
      else if (get_item_check(IDD_TextConvert_AsBW))
      {
	End(IDD_TextConvert_AsBW);
      }
      else
      {
	End(0);
      }
      return(1);

     case IDCANCEL:
      End(0);
      
     default:
      break;
    }
    break;
    
   case WM_CLOSE:
    End(0);
    return(1);
  }
  return(0);
}

// ------------------------------------------------------------
// Text format dialog

LRESULT_T
TextFormDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    set_item_check(IDD_TextConvert_OneCRasPar);
    return 1;
    
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDOK:
      if (get_item_check(IDD_TextConvert_OneCRasPar))
      {
	End(IDD_TextConvert_OneCRasPar);
      }
      else if (get_item_check(IDD_TextConvert_OneCRasLF))
      {
	End(IDD_TextConvert_OneCRasLF);
      }
      else if (get_item_check(IDD_TextConvert_TwoCRs))
      {
	End(IDD_TextConvert_TwoCRs);
      }
      else if (get_item_check(IDD_TextConvert_TwoCRsLineBreak))
      {
	End(IDD_TextConvert_TwoCRsLineBreak);
      }
      else
      {
	End(0);
      }
      return 1;

     case IDCANCEL:
      End(0);
      return 1;
      
     default:
      break;
    }
    break;
    
   case WM_CLOSE:
    End(0);
    return(1);
  }
  return(0);
}

TextFormDialog::TextFormDialog()
{
  this->class_name = "TextForm";
}
