// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: updatefi.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// LayoutTemplate class
// t[ꂽAꂽAt[ANV
// NƂɁAev[gCX^XJ鑀sȂ
// W[

#include "pword.h"
#include "pllist.h"
#include "pmlist.h"
#include "tflist.h"
#include "layoutte.h"
#include "layoutin.h"
#include "frametem.h"
#include "frameins.h"
#include "bufnew.h"
#include "dli.h"
#include "docconte.h"
#include "docprese.h"
#include "document.h"
#include "docwindo.h"
#include "dpm.h"
#include "fission.h"
#include "fissioni.h"
#include "pagemap.h"
#include "pagesize.h"
#include "panel.h"
#include "pmli.h"
#include "pwordbas.h"
#include "table.h"
#include "tablepnl.h"
#include "textflow.h"

void 
LayoutTemplate::FI_CreateFrameTemplate(FrameTemplate* prev,
					FrameTemplate* ft)
{
  DocPageMapIterator dpm(GetDocumentContent());
  if (prev == 0) 
  {
    // first creation
    for (PageMap* pm = dpm.GetTemplatePageMap(this);
	 pm != 0;
	 pm = dpm.GetTemplatePageMap(this)) 
    {
      // text-flow mapping
      TextFlow* tf = new TextFlow(GetDocumentContent());
      pm->Add(ft, tf);
      // initiate text-flow
      tf->SeedParagraph();
      PageMapLayoutIterator pmli(pm);
      for (LayoutInstance* li = pmli();
	   li != 0;
	   li = pmli()) 
      {
	new FrameInstance(ft, (FrameInstance*)0, li);
      }
    }
  }
  else 
  {
    // flow to creation
    for (PageMap* pm = dpm.GetTemplatePageMap(this);
	 pm != 0;
	 pm = dpm.GetTemplatePageMap(this)) 
    {
      PageMapLayoutIterator pmli(pm);
      for (LayoutInstance* li = pmli();
	   li != 0;
	   li = pmli()) 
      {
	FrameInstance* prev_fi = li->FindFIByFT(prev);
	new FrameInstance(ft, prev_fi, li);
      }
    }
  }
}

// update frame-instance when vanish frame-template
void 
LayoutTemplate::FI_VanishFrameTemplate(FrameTemplate* vanish_ft)
{
  DocumentContent* doc_con = GetDocumentContent();
  switch (kind) 
  {
   case TableTemplate:
    {
#if defined(BCC31)
      PLListIterator plli((AvlSearch*)* (doc_con->GetPanelList()));
#else
      PLListIterator plli(* (doc_con->GetPanelList()));
#endif
      for (Panel* pl = plli(); pl != 0; pl = plli()) 
      {
	if (pl->GetPanelID() == Panel::TablePanelID) 
	{
	  PageMap* pm = (PageMap*) ((TablePanel*)pl)->GetTable();
	  if (pm->GetLayoutTemplate() == this) 
	  {
	    pm->RemoveInstance(vanish_ft);
	    break;
	  }
	}
      }
    }
    break;
   case RegularTemplate:
    {
      PMListIterator pmli(*doc_con->GetPMList());
      for (PageMap* pm = pmli(); pm != 0; pm = pmli()) 
      {
	if (pm->GetLayoutTemplate() == this) 
	{
	  pm->RemoveInstance(vanish_ft);
	}
      }
    }
    break;
   case PageSizeTemplate:
    {
      PageMap* pm = (PageMap*)doc_con->GetPageSize();
      if (pm->GetLayoutTemplate() == this) 
      {
	pm->RemoveInstance(vanish_ft);
      }
    }
    break;
  }
}

// update all frame-instance(when size changed, ...)
void 
LayoutTemplate::DelayFormatFrame(FrameTemplate* ft)
{
  DocPageMapIterator dpm(GetDocumentContent());
  for (PageMap* pm = dpm.GetTemplatePageMap(this);
       pm != 0;
       pm = dpm.GetTemplatePageMap(this)) 
  {
    PageMapLayoutIterator pmli(pm);
    for (LayoutInstance* li = pmli();
	 li != 0;
	 li = pmli()) 
    {
      FrameInstance* fi = li->FindFIByFT(ft);
      if (fi != 0) 
      {
	fi->ReportTextFlow();
      }
    }
  }
}

// update changed next frame
void 
LayoutTemplate::FI_ChangedNext(FrameTemplate* changed)
{
  DocPageMapIterator dpm(GetDocumentContent());
  for (PageMap* pm = dpm.GetTemplatePageMap(this);
       pm != 0;
       pm = dpm.GetTemplatePageMap(this)) 
  {
    PageMapLayoutIterator pmli(pm);
    for (LayoutInstance* li = pmli();
	 li != 0;
	 li = pmli()) 
    {
      FrameInstance* changed_fi = li->FindFIByFT(changed);
      if (changed_fi != 0) 
      {
	changed_fi->PrepareToChangeFlow();
      }
    }
  }
}

// it's the only frame in this pipe
// check vanish frame instance
bool 
LayoutTemplate::FI_CheckVanishFrameTemplate(FrameTemplate* vanish_ft)
{
  // main loop(all assigned text flow)
  DocPageMapIterator dpm(GetDocumentContent());
  for (PageMap* pm = dpm.GetTemplatePageMap(this);
       pm != 0;
       pm = dpm.GetTemplatePageMap(this)) 
  {
    
    // find text-flow
    uword gate = WhichGateFT(vanish_ft);
    TextFlow* tf = pm->GetGateTF(gate);
    if (tf == 0) 
    {
      continue;
    }
    
    // check empty textflow
    if (tf->IsEmpty()) 
    {
      if ((tf->GetNext() == 0) &&
	  (tf->GetPrev() == 0)) 
      {
	// it's the only one text-flow of this document
	// we can't delete this text-flow
	return False;
      }
      continue;
    }
    
    bool safe = False;
    // check the only one frame in assigned text-flow
    DocPageMapIterator dpm2(GetDocumentContent());
    for (PageMap* pm2 = dpm2(); pm2 != 0; pm2 = dpm2()) 
    {
      if ((pm2->GetLayoutTemplate() != this) && 
	  (pm2->GetGateNumber(tf) != 0)) 
      {
	// this flow is ok!
	safe = True;
	break;
      }
    }
    if (safe == False) 
    {
      return False;
    }
  }
  return True;
}
