// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: vdisplay.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// VDisplay class
// zfBXvCNX

#include "pword.h"
#include "layoutte.h"
#include "layoutin.h"
#include "view.h"
#include "rect.h"
#include "vdisplay.h"

// constructor
VDisplay::VDisplay(View* view, LayoutInstance* li)
{
  VDisplay::view = view;
  iunits_base.Set(li->GetLX(), 
                   li->GetLY(), 
                   li->GetLX() + li->GetWidth() - 1, 
                   li->GetLY() + li->GetHeight() -1);
}

// get DC
HDC 
VDisplay::GetDC()
{
  return view->GetDC();
}

bool 
VDisplay::IsPrinter()
{
  return(view->GetDeviceType() == PRINTER);
}


// Dunit converter
//
// Iunit to Dunit ----> view->Dunit@ (iunits_base + iunits_pos)

// convert to Dunit x
Dunit 
VDisplay::ItoWx(Iunit x)
{
  return view->DunitX(iunits_base.x1 + (Lunit)x);
}

// convert to Dunit y
Dunit 
VDisplay::ItoWy(Iunit y)
{
  return view->DunitY(iunits_base.y1 + (Lunit)y);
}

// convert to Dunit vector
VectW 
VDisplay::ItoWv(Vector& v)
{
  return VectW(view->DunitX(iunits_base.x1 + (Lunit)v.x),
                view->DunitY(iunits_base.y1 + (Lunit)v.y));
}

// RECT converter
RECT 
VDisplay::ItoWR(View* v, Rect& r)
{
  RECT rect;
  rect.left   = v->DunitX(iunits_base.x1 + (Lunit)r.x1);
  rect.top    = v->DunitY(iunits_base.y1 + (Lunit)r.y1);
  rect.right  = v->DunitX(iunits_base.x1 + (Lunit)r.x2 + 1);
  rect.bottom = v->DunitY(iunits_base.y1 + (Lunit)r.y2 + 1);
  return rect;
}

RECT
VDisplay::ItoWR(Rect& r)
{
  return(this->ItoWR(this->view, r));
}
