// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: view.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class View

#ifndef VIEW_H
#define VIEW_H

#include "rect.h"

class View
{
private:
  // base position
  Lpoint view_point[1];
  
  // Windows device context.
  HDC dc;
  
  // Logical device dpi
  int internal_dpi;
  
  // dc cacheing
  Dpoint device_dpi[1];
  
  // PRINTER or SCREEN.
  int device_type;
  
  int dc_is_mine;
  
public:
  View::View();
  
protected:
  virtual HDC View::GetTrueDC();
  virtual HWND View::MaybeGetWindowHandle();
  virtual void View::ReleaseTrueDC(HDC dc);
  
  // lexical method
private:
  void NEAR View::SetupNewDC();
public:
  Dunit View::DunitX(Lunit lx);
  Dunit View::DunitY(Lunit ly);
  Dunit View::ScaleDunitX(Lunit lx);
  Dunit View::ScaleDunitY(Lunit ly);
  Dunit View::lpos_to_dpos(Lunit lxy, int index_xy);
  Dunit View::lu_to_du(Lunit lxy, int index_xy);
  HDC View::GetDC();
  Lunit View::GetLX();
  Lunit View::GetLY();
  Lunit View::LunitX(Dunit wx);
  Lunit View::LunitY(Dunit wy);
  Lunit View::ScaleLunitX(Dunit wx);
  Lunit View::ScaleLunitY(Dunit wy);
  Lunit View::dpos_to_lpos(Dunit dxy, int index_xy);
  Lunit View::du_to_lu(Dunit dxy, int index_xy);
  int View::GetDeviceDPIX();
  int View::GetDeviceDPIY();
  int View::GetDeviceType();
  int View::GetInternalDPI();
  int View::LXUnit();
  int View::LYUnit();
  int View::WXUnit();
  int View::WYUnit();
  long View::LongDunitX(Lunit lx);
  long View::LongDunitY(Lunit ly);
  long View::ScaleLongDunitX(Lunit lx);
  long View::ScaleLongDunitY(Lunit ly);
  long View::lpos_to_long_dpos(Lunit lxy, int index_xy);
  long View::lu_to_long_du(Lunit lxy, int index_xy);
  void View::ReleaseDC();
  void View::ResetDC();
  void View::SetDC(HDC dc);
  void View::SetDeviceType(int device_type);
  void View::SetInternalDPI(int internal_dpi);
  void View::SetLX(Lunit lx);
  void View::SetLY(Lunit ly);
  void View::SetScaling(int scaling);
  void View::dpoint_to_lpoint(Dpoint* dp, Lpoint* lp);
  void View::lpoint_to_dpoint(Lpoint* lp, Dpoint* dp);
  void View::lrect_to_drect(Lrect* lr, Drect* dr);
  void View::set_brush_org(Drect* dr, HBRUSH brush);
};

extern View Default_View[1];
extern View Printer_View[1];

inline Lunit
View::GetLX()
{
  return(POINT_X(this->view_point));
}

inline void
View::SetLX(Lunit lx)
{
  POINT_X(this->view_point) = lx;
}

inline Lunit
View::GetLY()
{
  return(POINT_Y(this->view_point));
}

inline void
View::SetLY(Lunit ly)
{
  POINT_Y(this->view_point) = ly;
}

inline int
View::GetDeviceType()
{
  return(this->device_type);
}

inline void
View::SetDeviceType(int device_type)
{
  this->device_type = device_type;
}

inline int
View::GetInternalDPI()
{
  return(this->internal_dpi);
}

inline void
View::SetInternalDPI(int internal_dpi)
{
  this->internal_dpi = internal_dpi;
}

inline int
View::GetDeviceDPIX()
{
  return(POINT_X(this->device_dpi));
}

inline int
View::GetDeviceDPIY()
{
  return(POINT_Y(this->device_dpi));
}

// Convert logical size LXY to device size.
inline Dunit
View::lu_to_du(Lunit lxy, int index_xy)
{
  return((Dunit) this->lu_to_long_du(lxy, index_xy));
}

// Convert logical position LXY to device position.
inline Dunit
View::lpos_to_dpos(Lunit lxy, int index_xy)
{
  return((Dunit) this->lpos_to_long_dpos(lxy, index_xy));
}

// Convert logical size LX to device size.
inline Dunit
View::ScaleDunitX(Lunit lx)
{
  return((Dunit) this->ScaleLongDunitX(lx));
}

// Convert logical size LY to device size.
inline Dunit
View::ScaleDunitY(Lunit ly)
{
  return((Dunit) this->ScaleLongDunitY(ly));
}

// Convert logical position LX to device position.
inline Dunit
View::DunitX(Lunit lx)
{
  return((Dunit) this->LongDunitX(lx));
}

// Convert logical position LY to device position.
inline Dunit
View::DunitY(Lunit ly)
{
  return((Dunit) this->LongDunitY(ly));
}

#endif /* VIEW_H */
