// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: vmem.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// mask difference between "newed" memory and global-alloced memory

#include <memory.h>
#include "pword.h"
#include "vmem.h"

VMem::~VMem()
{
  ;
}

VMem*
VMem::Make(udword size)
{
  int l = 1;
  while (size >>= 1)
  {
    l++;
  }
  
  VMem* nw;
  if (l <= 15)
  {
    // can't fail
    nw = new VMemSmall(l);
  }
  else
  {
    // can fail, but in this case we continue to carry around
    // the VMem object, with a "stuff" of NULL
    // people writing into it have to check
    nw = new VMemBig(l);
  }
  nw->force_big = False;
  nw->l = l;
  nw->size = 1L << l;
  return nw;
}

VMem*
VMem::Make(int l, bool force_big)
{
  VMem* nw;
  if ((l <= 15) && !force_big)
  {
    nw = new VMemSmall(l);
  }
  else
  {
    nw = new VMemBig(l);
  }
  nw->force_big = force_big;
  nw->l = l;
  nw->size = 1L << l;
  return nw;
}

VMem*
VMem::CopyHandle(HANDLE h)
{
  udword size = ::GlobalSize(h);
  VMem* vm = Make(size);
  void* dist = vm->GetStuff();
  void* lp = (void*)::GlobalLock(h);
  if ((dist != NULL) && (lp != NULL))
  {
    huge_memcpy(dist, 0, lp, 0, size);
    ::GlobalUnlock(h);
  }
  else 
  {
    delete vm;
    return NULL; 
  }
  return vm;
}

VMem*
VMem::Duplicate(VMem* vm)
{
  udword size = vm->size;
  VMem* new_vm = Make(size);
  void* source = vm->GetStuff();
  void* dist   = new_vm->GetStuff();
  if ((source != NULL) && (dist != NULL))
  {
    huge_memcpy(dist, 0, source, 0, size);
  }
  else 
  {
    delete new_vm;
    return 0; 
  }
  return new_vm;
}

HANDLE
VMem::CopyToHandle()
{
  HANDLE hmem = ::GlobalAlloc(GHND, size);
  if (hmem)
  {
    void* lp = ::GlobalLock(hmem);
    if (lp)
    {
      void* source = this->GetStuff();
      if (source != NULL)
      {
	huge_memcpy(lp, 0, source, 0, size);
      }
      ::GlobalUnlock(hmem);
    }
    else
    {
      ::GlobalFree(hmem);
      hmem = 0;
    }
  }
  return hmem;
}

VMem*
VMem::Double(udword min_size)
{
  int new_l = l;
  udword new_size = size;
  while ((new_size < 0x80000000UL) && (new_size < min_size))
  {
    new_size *= 2;
    new_l++;
  }
  if (new_size >= 0x80000000UL)
  {
    return 0;
  }
  return this->Remake(new_l);
}

// ------------------------------------------------------------
// VMemSmall

VMemSmall::VMemSmall(int l)
{
  stuff = ::xmalloc_on_log2(l);
  this->l = l;
}

VMemSmall::~VMemSmall()
{
  ::xfree_on_log2(this->stuff, this->l);
}

VMem*
VMemSmall::Remake(int l)
{
  if (l <= this->l)
  {
    return this;
  }
  VMem* nw;
  if (l > 15)
  {
    // switch from our memory to Windows
    nw = Make(l, force_big);
    if ((nw->stuff != NULL) && (this->stuff != NULL))
    {
      huge_memcpy(nw->stuff, 0L, this->stuff, 0L, this->size);
    }
    delete this;
    return nw;
  }
  else
  {
    void* new_stuff = ::xmalloc_on_log2(l);
    memcpy(new_stuff, this->stuff, (size_t)(this->GetSize()));
    ::xfree_on_log2(stuff, this->l);
    this->stuff = new_stuff;
    this->l = l;
    this->size = 1L << this->l;
    return this;
  }
}

bool
VMemSmall::IsHuge()
{
  return False;
}

// ------------------------------------------------------------
// VMemBig

VMemBig::VMemBig(int l)
{
  this->h = ::GlobalAlloc(GMEM_MOVEABLE, 1L << l);
  if (this->h)
  {
    this->stuff = ::GlobalLock(h);
  }
  else 
  {
    this->stuff = 0;
  }
  this->l = l;
  read_only = False;
}

VMemBig::VMemBig(void* mem)
{
  this->stuff = mem;
  this->h = 0;
  this->read_only = True;
}

VMemBig::VMemBig(HANDLE h, bool read_only)
{
  this->read_only = read_only;
  this->h = h;
  if (this->h)
  {
    this->stuff = ::GlobalLock(this->h);
    this->size = ::GlobalSize(this->h);
  }
  else
  {
    this->stuff = NULL;
  }
}

VMemBig::~VMemBig()
{
  if (this->h)
  {
    ::GlobalUnlock(h);
    if (!read_only)
    {
      ::GlobalFree(h);
    }
  }
}

HANDLE
VMemBig::GrabHandle()
{
  HANDLE ret = this->h;
  if (ret)
  {
    ::GlobalUnlock(ret);
  }
  this->h = 0;
  return ret;
}

VMem*
VMemBig::Remake(int l)
{
  if (l <= this->l)
  {
    return this;
  }

  this->size = 1L << l;
  this->l = l;

  if (this->h != NULL)
  {
    ::GlobalUnlock(h);
    this->h = ::GlobalReAlloc(this->h, this->size, GMEM_MOVEABLE);
    if (this->h)
    {
      this->stuff = ::GlobalLock(this->h);
    }
    else
    {
      this->stuff = NULL;
    }
  }
  
  return this;
}

bool
VMemBig::IsHuge()
{
  return True;
}
