// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: vtext.cpp,v 3.4 1999/05/15 17:47:58 kudou Exp $
// implement VText class for virtual text

#include "pword.h"
#include <time.h>
#include "vtext.h"
#include "dialogs.h"
#include "document.h"
#include "fileutil.h"
#include "makenum.h"
#include "pref.h"
#include "pstreams.h"

void
VText::WriteHeader(PStream* stream)
{
  stream->StartBlockOut(PStream::HDR_VTEXT);
  CHECK;
  
  stream->OutUWord(id);
  CHECK;
}

void
VText::WriteTrailer(PStream* stream)
{
  stream->EndBlockOut();
}

VText*
VText::MakeFromStream(PStream* stream, Document* doc)
{
  word vers;
  stream->StartTypedBlockIn(PStream::HDR_VTEXT, vers);
  CHECK 0;
  
  VTextID id = (VTextID)stream->InUWord();
  CHECK 0;
  
  VText* result = Make(doc, id);
  if (result)
  {
    result->ReadFromStream(stream);
    CHECK 0;
  }
  
  stream->EndBlockIn();
  CHECK 0;
  return result;
}

VText*
VText::Make(Document* doc, VTextID id)
{
  switch (id)
  {
   case PageNoVTextID:
    return new VTextPageNo(doc);
   case FileNameVTextID:
    return new VTextFileName(doc);
   case TimeVTextID:
    return new VTextTime(doc);
   case NoneVTextID:
   default:
    return 0;
  }
}

sjis*
VTextPageNo::Evaluate(int p)
{
  return VText::MakeNum(p, format);
}

void
VTextPageNo::WriteToStream(PStream* stream)
{
  WriteHeader(stream);
  stream->OutUWord(format); CHECK;
  WriteTrailer(stream);
}

void
VTextPageNo::ReadFromStream(PStream* stream)
{
  format = stream->InUWord();
  if (stream->GetError() == SE_NOMORE)
  {
    format = IDD_VTTime_Hankaku;
    stream->SetError(SE_NOERROR);
  }
}

sjis* 
VTextFileName::Evaluate(int)
{
  // hLgł͂ȂAt@CgƁB (konno)
  char* name = FileUtil::GetFileNameOnly(doc->GetPathName());
  return(jisz_spread(name[0] == '\0' ? doc->GetName() : name, NULL));
}

void
VTextFileName::WriteToStream(PStream* stream)
{
  WriteHeader(stream);
  WriteTrailer(stream);
}

void
VTextFileName::ReadFromStream(PStream*)
{
}

VTextTime::VTextTime(Document* doc)
  : VText(TimeVTextID, doc)
{
}

VTextTime::VTextTime(VTextTime& copy)
  : VText(TimeVTextID, doc)
{
  for (int i = 0; i<MAX; i++)
  {
    vals[ i ] = copy.vals[ i ];
  }
}

VTextTime::VTextTime(int _what, int _how)
  : VText(TimeVTextID, 0)
{
  vals[ what ] = _what;
  vals[ how ] = _how;
}

VTextTime::~VTextTime()
{
}

sjis*
VTextTime::Evaluate(int)
{
  time_t timer;
  time(&timer);
  struct tm* info = localtime(&timer);
  int val;
  
  switch (vals[ what ])
  {
   case IDD_VTTime_Seconds:
    val = info->tm_sec;
    break;

   case IDD_VTTime_Minutes:
    val = info->tm_min;
    break;

   case IDD_VTTime_Hours:
    val = info->tm_hour;
    break;

   case IDD_VTTime_Day:
    val = info->tm_mday;
    break;

   case IDD_VTTime_DayOfWeek:
    return(sjis*) make_weekday(info->tm_wday);

   case IDD_VTTime_Month:
    val = info->tm_mon+1;
    break;
    
    // 2 digit year
   case IDD_VTTime_Year:
    val = info->tm_year % 100;
    return VText::MakeNum2(val, vals[how]);

    // 4 digit year
   case IDD_VTTime_Year4:
    val = info->tm_year + 1900;
    break;

   case IDD_VTTime_HeiseiYear:
    val = info->tm_year - Pref_gengo_start;
    break;
    
  }
  return VText::MakeNum(val, vals[how]);
}

void
VTextTime::WriteToStream(PStream* stream)
{
  WriteHeader(stream);
  CHECK;
  
  int mx = MAX;
  stream->OutUWord(mx);
  CHECK;
  int* v = vals;
  while (mx--)
  {
    stream->OutWord(*v++);
    CHECK;
  }
  WriteTrailer(stream);
}

void
VTextTime::ReadFromStream(PStream* stream)
{
  int mx = stream->InUWord();
  int* v = vals;
  while (mx--)
  {
    *v++ = stream->InWord();
  }
}

sjis* 
VText::MakeNum(int val, uword format)
{
  char buf[16];
  wsprintf(buf, "%d", val);
  
  switch (format)
  {
   case IDD_VTTime_Zenkaku:
    return((sjis*) make_number(buf, ZENKAKU_NUM));
    
   case IDD_VTTime_Kansuu:
    return((sjis*) make_number(buf, SINO_NUM | UNITS_NUM));
    
    // Safety coding when FORMAT is illegal.
    // case IDD_VTTime_Hankaku:
   default:
    return(jisz_spread(buf, NULL));
  }
}

sjis* 
VText::MakeNum2(int val, uword format)
{
  char buf[16];
  wsprintf(buf, "%02d", val);
  
  switch (format)
  {
   case IDD_VTTime_Zenkaku:
    return((sjis*) make_number(buf, ZENKAKU_NUM));
    
   case IDD_VTTime_Kansuu:
    return((sjis*) make_number(buf, SINO_NUM | UNITS_NUM));
    
    // Safety coding when FORMAT is illegal.
    // case IDD_VTTime_Hankaku:
   default:
    return(jisz_spread(buf, NULL));
  }
}
