// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: vtext.h,v 3.3 1999/05/15 17:47:58 kudou Exp $
// define VText class for handling virtual text

#ifndef VTEXT_H
#define VTEXT_H

#include "dialogs.h"

class VText
{
public:
  enum VTextID
  {
    NoneVTextID = 0,
    PageNoVTextID,
    FileNameVTextID,
    TimeVTextID,    
  };
  
private:
  VTextID id;
  
protected:
  Document* doc;

private:
  static VText* Make(Document* doc, VTextID);

protected:
  VText(VTextID _id, Document* _doc) 
  { 
    id = _id; 
    doc = _doc; 
  }
  void WriteHeader(PStream*);
  void WriteTrailer(PStream*);
  static sjis* MakeNum(int, uword);
  // for force 2 digit make number
  static sjis* MakeNum2(int, uword);
  
public:
  virtual ~VText() {}

  virtual sjis* Evaluate(int p) = 0;
  virtual void ReadFromStream(PStream* stream) = 0;
  virtual void WriteToStream(PStream* stream) = 0;
  static VText* MakeFromStream(PStream* stream, Document* doc);
  VTextID GetVTextID() 
  {
    return id;
  }
};

class VTextPageNo
  : public VText
{
  uword format;
public:
  VTextPageNo(Document* doc, uword _format = IDD_VTTime_Hankaku) 
   : VText(PageNoVTextID, doc)
    , format(_format)
  {
  }
  
  sjis* Evaluate(int p);
  virtual void ReadFromStream(PStream* stream);
  virtual void WriteToStream(PStream* stream);
};

class VTextFileName
  : public VText
{
public:
  VTextFileName(Document* doc) 
   : VText(FileNameVTextID, doc)
  {}

  sjis* Evaluate(int p);
  virtual void ReadFromStream(PStream* stream);
  virtual void WriteToStream(PStream* stream);
};

class VTextTime
  : public VText
{
  friend class VTTimeDialog;
  
private:
  // used only for virtual text time
  enum { what=0, how=1, MAX=2 };
	
  // there are two values being maintained here -- one is
  // the "what" (day, month etc.), and the other is the how
  // (format of number)
  int vals[ MAX ];

public:
  VTextTime(Document*);
  VTextTime(VTextTime&);
  VTextTime(int what, int how);
  ~VTextTime();
  sjis* Evaluate(int p);
  virtual void ReadFromStream(PStream* stream);
  virtual void WriteToStream(PStream* stream);
};

#endif /* VTEXT_H */
