// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: vtextpnl.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class VTextPanel
// ϕ\APanelpꂽNXB

#include "pword.h"
#include "pstreams.h"
#include "docconte.h"
#include "bufnew.h"
#include "interval.h"
#include "sjis.h"
#include "vtextpnl.h"
#ifndef NDEBUG
#include "ddisplay.h"
#endif

// get panel id
PREFIX(Panel)PanelID VTextPanel::GetPanelID()
{
  return VTextPanelID;
}

// initialize
void 
VTextPanel::Init()
{
  vtext = NULL;
  stuff = NULL;
}

// constructor
VTextPanel::VTextPanel(DocumentContent* doc, BufferPointer* bpp, VText* vtext)
  : Panel(doc, bpp, 0, 0)
{
  Init();
  this->vtext = vtext;
  Evaluate(0);
}

// constructor for file read
VTextPanel::VTextPanel(DocumentContent* doc, BufferPointer* bpp)
  : Panel(doc, bpp, 0, 0)
{
  Init();
}

// terminate
void 
VTextPanel::Term()
{
  delete vtext;
  delete stuff;
}

// destructor
VTextPanel::~VTextPanel()
{
  Term();
}

// get additional width
Iunit 
VTextPanel::GetAdditionalWidth()
{
  return 0;
}

// get additional height
Iunit 
VTextPanel::GetAdditionalHeight()
{
  return 0;
}

// change panel size
void 
VTextPanel::ChangeSize(Iunit width, Iunit height)
{
  Panel::ChangeSize(width, height);
}

// update panel position
void 
VTextPanel::SetPanelPosition(Lunit /*pos_x*/, Lunit /*pos_y*/)
{
  // what is this supposed to do?
}

// save
void 
VTextPanel::WriteToStream(PStream* stream)
{
  // write panel header
  Panel::WriteHeaderToStream(stream);
  CHECK;
  
  // write table-panel header
  int header = PStream::HDR_VTEXTPANEL;
  stream->OutUWord(header);
  CHECK;
  
  // save vtext info
  vtext->WriteToStream(stream);
  CHECK;
  
  // write current data to stream
  int len = jislen(stuff) + 1;
  stream->OutUWord(len);
  CHECK;
  stream->Out(stuff, len * sizeof(sjis));
  CHECK;
}

// ascii save
void
VTextPanel::WriteASCIIToStream(BufStream* stream)
{
  sjis* wide = GetWideString();
  int foo_len;
  char* foo = jis_squeeze(wide, jislen(wide), &foo_len);
  stream->Put(foo, foo_len);
  delete foo;
}

// load
Panel* 
VTextPanel::ReadFromStream(DocumentContent* doc, BufferPointer* bpp, 
			    PStream* stream)
{
  // read header
  int header = stream->InUWord();
  CHECK 0;
  
  if (header != PStream::HDR_VTEXTPANEL)
  {
    // header error
    return 0;
  }
  
  VTextPanel* tp = new VTextPanel(doc, bpp);
  tp->vtext = VText::MakeFromStream(stream, doc->GetDocument());
  
  int len = stream->InUWord();
  CHECK 0;
  tp->stuff = new sjis[ len ];
  if (tp->stuff)
  {
    stream->In(tp->stuff, len*sizeof(sjis));
  }
  CHECK 0;
  
  return tp;
}

void 
VTextPanel::Mark(PStream* /*stream*/)
{
}

// update panel's contents
bool
VTextPanel::Evaluate(int p)
{
  sjis* new_stuff = this->GetVText() ->Evaluate(p);
  sjis* old_stuff = this->stuff;
  this->stuff = new_stuff;
  bool ret = True;
  if (old_stuff)
  {
    int length;
    if (this->GetVText() ->GetVTextID() != VText::PageNoVTextID
	&& jislen(new_stuff) == (length = jislen(old_stuff))
	&& jiscmp(new_stuff, old_stuff, length) == 0)
    {
      ret = False;
    }
    delete(old_stuff);
  }
  return(ret);
}

// delay format the panel
void 
VTextPanel::DelayFormat()
{
  BufferPointer* bp = this->GetOwnedRealBP();
  Interval i(bp);
  delete bp;
  i.DelayFormat();
}

// get layout -- dummy
LayoutInstance* 
VTextPanel::GetLayout()
{
  return NULL;
}
