// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: vtextpnl.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class VTextPanel
// ϕ\APanelpꂽNXB

#ifndef VTEXTPNL_H
#define VTEXTPNL_H

#include "panel.h"

class Table;
class VText;

class VTextPanel
  : public Panel
{
private:
  // which table
  Table* table;
  
  // virtual text
  VText* vtext;
  
  // contents
  // zero-terminated
  sjis* stuff;
  
private:
  // get panel id
  PanelID GetPanelID();
  
  // initialize
  void Init();
  
  // terminate
  void Term();
  
protected:
  // get additional width
  Iunit GetAdditionalWidth();
  
  // get additional height
  Iunit GetAdditionalHeight();
  
  // get layout offset
  Vector GetLayoutOffset();
  
public:
  VTextPanel(DocumentContent* doc, BufferPointer* bpp, VText* vtext);
  
  // constructor for file read
  VTextPanel(DocumentContent* doc, BufferPointer* bpp);
  
  // destructor
  ~VTextPanel();
  
  // change panel size
  void ChangeSize(Iunit width, Iunit height);
  
  // get virtual text
  VText* GetVText()
  {
    return vtext;
  }
  
  // update panel position
  // this method is virtual function.
  void SetPanelPosition(Lunit pos_x, Lunit pos_y);
  
  // load
  static Panel* ReadFromStream(DocumentContent* doc, 
				BufferPointer* bpp, PStream* ps);
  
  // save
  void WriteToStream(PStream* ps);
  
  // ascii save
  void WriteASCIIToStream(BufStream* ps);
  
  // mark
  void Mark(PStream*);
  
  void Format();
  
  // get layout
  LayoutInstance* GetLayout();
  
  // update the panel's contents
  bool Evaluate(int);
  
  // reformat the panel
  void DelayFormat();
  
  sjis* GetWideString();
};

inline sjis* 
VTextPanel::GetWideString()
{
  return(this->stuff);
}

#endif /* VTEXTPNL_H */
