// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: window.cpp,v 3.3 1999/05/18 18:03:09 kudou Exp $
// implement Window class

#include "pword.h"
#include "window.h"
#include "mwindow.h"
#include "screen.h"

Window::Window()
{
  this->hWnd = 0;
}

void
Window::Destroy()
{
  if (this->GetHandle())
  {
    ::DestroyWindow(this->GetHandle());
    this->hWnd = 0;
   }
}

Window::~Window()
{
  this->Destroy();
}

int
Window::IsWindow()
{
  return(this->GetHandle() != 0 && (int) ::IsWindow(this->GetHandle()));
}

int
Window::Show(int command)
{
  return(this->IsWindow() ? (int) ::ShowWindow(this->GetHandle(), command)
	  : 0);
}

int
Window::Show()
{
  return(this->Show(SW_SHOW));
}

int
Window::Hide()
{
  return(this->Show(SW_HIDE));
}

void
Window::InvalidateRect(RECT* r)
{
  if (this->IsWindow())
  {
    ::InvalidateRect(this->GetHandle(), r, False);
  }
}

void
Window::InvalidateAll()
{
  if (this->IsWindow())
  {
    ::InvalidateRect(this->GetHandle(), NULL, True);
  }
}

void
Window::Update()
{
  if (this->IsWindow())
  {
    ::UpdateWindow(this->GetHandle());
  }
}

LRESULT
Window::SendMessage(UINT msg, WPARAM_T wparam, LPARAM_T lparam)
{
  return(this->IsWindow()
	  ? ::SendMessage(this->GetHandle(), msg, wparam, lparam) : 0);
}

LRESULT
Window::SendMessage(UINT msg, WPARAM_T wparam)
{
  return(this->SendMessage(msg, wparam, 0));
}

LRESULT
Window::SendMessage(UINT msg)
{
  return(this->SendMessage(msg, 0));
}

// lexical method
LRESULT
Window::DefWindowProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam)
{
  return ::DefWindowProc(this->GetHandle(), iMessage, wParam, lParam);
}

// virtual method
LRESULT_T
Window::WndProc(MSG_T, WPARAM_T, LPARAM_T)
{
  return(0);
}

void
Window::center_window()
{
  RECT mine;
  RECT main_rect;
  HWND handle = this->GetHandle();
  GetWindowRect(handle, &mine);
  main_rect.left = 0;
  main_rect.top = 0;
  main_rect.right = Screen::width;
  main_rect.bottom = Screen::height;
  if (main_window_handle != 0
      && ::IsWindow(main_window_handle) && !::IsIconic(main_window_handle))
  {
    GetWindowRect(main_window_handle, &main_rect);
  }
  int width = mine.right - mine.left;
  int height = mine.bottom - mine.top;
  int x = (main_rect.left + main_rect.right - width) / 2;
  int y = (main_rect.top + main_rect.bottom - height) / 2;
  if (Screen::width < x + width)
  {
    x = Screen::width - width;
  }
  if (x < 0)
  {
    x = 0;
  }
  if (Screen::height < y + height)
  {
    y = Screen::height - height;
  }
  if (y < 0)
  {
    y = 0;
  }
  MoveWindow(handle, x, y, width, height, False);
}

#ifndef NDEBUG
void
Window::CheckAtDebugTime()
{
  if (!this->IsWindow())
  {
    syserr("Window::Check: Bad window handle %d.", this->GetHandle());
  }
}
#endif
