// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: wndproc.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// generic wndprocs

#include "pword.h"
#include <stdlib.h>
#include "pwordpre.h"
#include "mwindow.h"
#include "dlg.h"
#include "screen.h"
#include "window.h"

LRESULT_T
xWndProc_ (HWND hWnd, MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam)
{
  Window* pWindow = GetPointer(hWnd);
  if (pWindow == NULL)
  {
    // If window is 0, maybe it is being created
    
    if (iMessage != WM_CREATE)
    {
      return(DefWindowProc(hWnd, iMessage, wParam, lParam));
    }
    
    LPCREATESTRUCT lpcs = (LPCREATESTRUCT) lParam;
    pWindow = (Window*) lpcs->lpCreateParams;
    pWindow->SetHandle(hWnd);
    SetPointer(hWnd, pWindow);
  }
  
  // One of our windows -- call its wndproc
  return(pWindow->WndProc(iMessage, wParam, lParam));
}

// wndproc for floating window(toolbox)

LRESULT_T
fWndProc_ (HWND hWnd, MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam)
{
  Window* pWindow = GetPointer(hWnd, DLGWINDOWEXTRA);
  if (pWindow == 0)
  {
    return(DefDlgProc(hWnd, iMessage, wParam, lParam));
  }
  return(pWindow->WndProc(iMessage, wParam, lParam));
}

// generic wndproc for mdi child windows

// Windows' elegant and streamlined design calls for the lParam
// parameter to a window procedure for the WM_CREATE message to
// point to a CREATESTRUCT, whose lpCreateParams member is the
// creation parameters message specified as the last argument
// to CreateWindow.
//
// This is for regular windows only, however,  For MDI windows,
// the lpCreateParams member craftily points at the MDICREATESTRUCT
// used in the MDI_CREATE message sent to the MDI client to create
// the child.  Our creation parameters, namely the "this" of the
// C++ window class instance, are buried in the lParam field of
// that structure. 
// 
// Since there is no way in a generic window procedure to tell
// whether this is a regular window or not, we have to create
// this alternative generic window procedure only for MDI children.
//
// It differs only in the way that it extracts "this", and that it
// calls the default procedure for MDI children.
 
LRESULT_T
mWndProc_ (HWND hWnd, MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam)
{
  Window* pWindow = GetPointer(hWnd);
  if (pWindow == NULL)
  {
    // If `pWindow' is NULL, maybe it is being created
    
    if (iMessage != WM_CREATE)
    {
      return(DefMDIChildProc(hWnd, iMessage, wParam, lParam));
    }
    
    LPCREATESTRUCT lpcs = (LPCREATESTRUCT) lParam;
    LPMDICREATESTRUCT mdi = (LPMDICREATESTRUCT) lpcs->lpCreateParams;
    pWindow = (Window*) mdi->lParam;
    SetPointer(hWnd, pWindow);
    
    // in the case of MDI windows, many messages may be dispatched
    // through this routine before the SendMessage actually creating
    // the window and returning the window handle(so it can be placed
    // in the C++ window class instance). Therefore, we take the
    // liberty of plugging the window right here.
    
    pWindow->SetHandle(hWnd);
  }

  // One of our windows -- call its wndproc
  return(pWindow->WndProc(iMessage, wParam, lParam));
}
