// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: xstr.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// string

#include "pword.h"
#include <stdlib.h>
#include "pmenus.h"
#include "xstr.h"

// Generate string from xstr.md
#undef DEFSTR
#define DEFSTR(name, string) char STATIC_NEAR name[] = string;
#include "xstr_m.h"

// Generate preference strings, keywords and documents.  I design there
// are separated area for performance.  (konno)

// Generate preference keyword strings
#define DEFSTR(name, string) char STATIC_NEAR SKEY_ ## name[] = string;
#define PREF_BOOLEAN(name, key, def, cust, fn, doc) \
DEFSTR(name, key)
#define PREF_ENUM(name, key, desc, cust, fn, doc) \
DEFSTR(name, key)
#define PREF_INTEGER(name, key, min, max, def, cust, fn, doc) \
DEFSTR(name, key)
#define PREF_MM0(name, key, min, max, def, cust, fn, doc) \
DEFSTR(name, key)
#define PREF_STRING(name, key, def, cust, fn, doc) \
DEFSTR(name, key)
#define PREF_STRING10(name, key, cust, fn, doc) \
DEFSTR(name, key)
#include "pref_m.h"
#undef DEFSTR

// Generate undo description strings
#define DEFUNDO(desc, j, e) char STATIC_NEAR S_ ## desc[] = LANG(j, e);
#include "undo_m.h"

// Generate preference document strings
#define DEFSTR(name, string) char STATIC_NEAR SDOC_ ## name[] = string;
#define PREF_BOOLEAN(name, key, def, cust, fn, doc) \
DEFSTR(name, doc)
#define PREF_ENUM(name, key, desc, cust, fn, doc) \
DEFSTR(name, doc)
#define PREF_INTEGER(name, key, min, max, def, cust, fn, doc) \
DEFSTR(name, doc)
#define PREF_MM0(name, key, min, max, def, cust, fn, doc) \
DEFSTR(name, doc)
#define PREF_STRING(name, key, def, cust, fn, doc) \
DEFSTR(name, doc)
#define PREF_STRING10(name, key, cust, fn, doc) \
DEFSTR(name, doc)
#include "pref_m.h"
#undef DEFSTR

// command table
static Command_Desc command_table[] =
{
#define DEFCOMMAND(idm_command, name, guide) { guide, name, idm_command, },
#include "cmd_m.h"
};

// vector of pointer of Command_Desc.
static Command_Desc** command_by_name_table = NULL;
static Command_Desc** command_by_idm_table = NULL;
static Command_Desc** command_by_guide_table = NULL;

int
get_command_table_length()
{
  return(NUMBER_OF(command_table));
}

Command_Desc**
get_command_by_name_table()
{
  return(command_by_name_table);
}

Command_Desc**
get_command_by_guide_table()
{
  return(command_by_guide_table);
}

static int CDECL
compare_guide(void const* a, void const* b)
{
  return(strcmp((*((Command_Desc**) a))->guide,
		  (*((Command_Desc**) b))->guide));
}

static int CDECL
compare_name(void const* a, void const* b)
{
  return(strcmp((*((Command_Desc**) a))->name,
		  (*((Command_Desc**) b))->name));
}

static int CDECL
compare_idm(void const* a, void const* b)
{
  return((*((Command_Desc**) a))->idm_code
	  - (*((Command_Desc**) b))->idm_code);
}

static Command_Desc*
find_command(Command_Desc** table,
	      Command_Desc* key, int(CDECL* fn) (void const*, void const*))
{
  Command_Desc **slot = ((Command_Desc**)
			 bsearch(&key,
				  table,
				  NUMBER_OF(command_table),
				  sizeof(Command_Desc*), fn));
  return(slot == NULL ? NULL : *slot);
}

Command_Desc*
command_by_idm(int idm_code)
{
  Command_Desc desc;
  desc.idm_code = idm_code;
  return(find_command(command_by_idm_table, &desc, compare_idm));
}

Command_Desc*
command_by_name(char* name)
{
  Command_Desc desc;
  desc.name = name;
  return(find_command(command_by_name_table, &desc, compare_name));
}

static Command_Desc**NEAR
make_unsorted_table()
{
  Command_Desc** table = ((Command_Desc**)
			  xmalloc_permanent(sizeof(Command_Desc *)
					     * NUMBER_OF(command_table)));
  Command_Desc* desc = command_table;
  Command_Desc** slot = table;
  for (int i = 0; i != NUMBER_OF(command_table); ++i, ++desc, ++slot)
  {
    *slot = desc;
  }
  return(table);
}

static Command_Desc** NEAR
make_sorted_table(int(CDECL*fn) (void const*, void const*))
{
  Command_Desc** table = make_unsorted_table();
  qsort(table, NUMBER_OF(command_table), sizeof(Command_Desc*), fn);
  return(table);
}

void
init_command_table()
{
  command_by_name_table = make_sorted_table(compare_name);
  command_by_idm_table = make_sorted_table(compare_idm);
  command_by_guide_table = make_sorted_table(compare_guide);
}
