// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: abbrevs.cpp,v 3.5 2000/05/04 13:44:01 kudou Exp $
// implement AbbrevTable and AbbrevEntry classes for abbreviations

#include "pword.h"

#ifdef BW2_ABBREV
#include "abbrevs.h"

#include "bound.h"
#include "docconte.h"
#include "document.h"
#include "interval.h"
#include "intlist.h"
#include "menu.h"
#include "pstreams.h"
#include "textflow.h"
#ifndef _WIN32
#  include <memory.h>
#endif

#define T AbbrevEntry
#define TABLE BaseAbbrevTable
#define SEG BaseAbbrevTableSeg
#define FORCE_MAKE_ENTRY
#include "tabletem.cpp"

AbbrevTable STATIC_NEAR GlobalAbbrevTable;

// EXTERNALLY VISIBLE ROUTINES FOR OUTSIDE WORLD

char* 
AbbrevTable::GetAbbrevData(int index)
{
  return(::get_abbrev_entry(index) .GetAbbrev());
}

void
AbbrevTable::MakeAbbrev(char* name, char* abbrev, Document* doc)
{
  AbbrevEntry entry(name, abbrev, doc);
  MakeEntry(entry);
}

int
AbbrevTable::GetAbbrevByName(char* name, Document* doc)
{
  unsigned int limit = this->GetNEntries();
  unsigned int a = 0;
  while (++a != limit)
  {
    AbbrevEntry& e = ::get_abbrev_entry(a);
    if ((e.GetDocument() == doc) && (strcmp(e.name, name) == 0))
    {
      return(a);
    }
  }
  return(0);
}

void
AbbrevTable::WriteAbbrevsInDocument(PStream* stream, Document* doc)
{
  stream->StartBlockOut(PStream::HDR_MTABLE);
  CHECK;
  
  // count number of Abbrevs on this document
  {
    unsigned int n = 0;
    unsigned int a = this->GetNEntries();
    while (--a)
    {
      if (::get_abbrev_entry(a) .GetDocument() == doc)
      {
	n++;
      }
    }
    stream->OutUWord(n);
    CHECK;
  }
  
  // write out Abbrevs on this document
  {
    unsigned int limit = this->GetNEntries();
    unsigned int a = 0;
    while (++a != limit)
    {
      AbbrevEntry& e = ::get_abbrev_entry(a);
      if (e.GetDocument() == doc)
      {
	e.WriteToStream(stream);
	CHECK;
      }
    }
  }
  
  stream->EndBlockOut();
}

void
AbbrevTable::ReadAbbrevsInDocument(PStream* stream, Document* doc)
{
  word vers;
  stream->StartTypedBlockIn(PStream::HDR_MTABLE, vers);
  CHECK;
  
  int n = stream->InUWord();
  CHECK;
  
  while (n--)
  {
    AbbrevEntry e;
    e.ReadFromStream(stream, doc);
    CHECK;
    this->MakeEntry(e);
  }
  
  stream->EndBlockIn();
}


void
AbbrevEntry::Init()
{
  *name = '\0';
  abbrev = 0;
  document = 0;
}

AbbrevEntry::AbbrevEntry()
{
  Init();
}

// construct from name and interval list

AbbrevEntry::AbbrevEntry(char* _name, char* abbrev, Document* d)
{
  Init();
  copy_string(name, _name, ABBREV_LEN+1);
  document = d;
  this->abbrev = abbrev;
}

void
AbbrevEntry::Destroy()
{
  delete abbrev;
  Init();
}

// private method
unsigned char NEAR
AbbrevEntry::GetHash()
{
  assert(sizeof(Document*) == 4);
  
  unsigned char* s = (unsigned char*) &this->document;
  unsigned char x = s[0] ^ s[1] ^ s[2] ^ s[3];
  
  s = (unsigned char*) this->name;
  unsigned char c;
  while ((c = *s++) != '\0')
  {
    x = x ^ (x << 3) ^ c;
  }
  return(x);
}

int
operator == (AbbrevEntry& e1, AbbrevEntry& e2)
{
  return(e1.document == e2.document
	  && lstrcmp(e1.name, e2.name) == 0);
}

unsigned int
AbbrevEntry::Enter()
{
  return GlobalAbbrevTable.MakeEntry(*this);
}

void
AbbrevEntry::WriteToStream(PStream* stream)
{
  stream->StartBlockOut(PStream::HDR_ABBREVENTRY);
  CHECK;
  
  stream->OutString(name);
  CHECK;
  
  uword len = strlen(GetAbbrev())+1;
  stream->OutUWord(len);
  CHECK;
  stream->OutHuge(GetAbbrev(), len);
  CHECK;
  
  stream->EndBlockOut();
  CHECK;
}

void
AbbrevEntry::ReadFromStream(PStream* stream, Document* d)
{
  word vers;
  stream->StartTypedBlockIn(PStream::HDR_ABBREVENTRY, vers);
  CHECK;
  
  char* s = stream->InString();
  CHECK;
  copy_string(name, s, ABBREV_LEN+1);
  delete s;
  
  SetDocument(d);
  
  uword len = stream->InUWord();
  CHECK;
  abbrev = new char [len];
  
  stream->InHuge(abbrev, len);
  
  stream->EndBlockIn();
}

void
AbbrevEntry::AddToInterface(unsigned int i, void*)
{
  Menu::add_menu(Menu_Type_ABBREV, i, this->name);
}

#ifndef NDEBUG
void
AbbrevEntry::DumpHeader(FILE* f)
{
  fprintf(f, 
	   "\nAbbrev Table\n\n"
	   "NNNN Name\n"
	 );
}

void
AbbrevEntry::Dump(unsigned int i, void* v)
{
  FILE* f = (FILE*) v;
  fprintf(f, "%4d %s\n", i, name);
}
#endif
#endif /* BW2_ABBREV */
