// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: abbrevs.h,v 3.3 2000/05/04 13:44:01 kudou Exp $
// define AbbrevTable and AbbrevEntry class to hold abbreviations

#ifdef BW2_ABBREV
#ifndef ABBREVS_H
#define ABBREVS_H

#include "generics.h"

class AbbrevEntry
  : public GenericEntry
{
  friend class BaseAbbrevTable;
  friend class AbbrevTable;

private:
  enum { ABBREV_LEN = 32 };
  char name[ ABBREV_LEN+1 ];
  char* abbrev;              // the abbreviation itself
  Document* document;        // document where abbrev was registered, and
                             // thus should be saved with
public:
  AbbrevEntry();
  AbbrevEntry(char* name, char* abbrev, Document*);

private:
  unsigned char NEAR GetHash();

public:
  void Destroy();
  void Init();
  char* GetAbbrev() const
  {
    return abbrev;
  }

  void SetAbbrev(char* abbrev)
  {
    this->abbrev = abbrev;
  }

  Document* GetDocument()
  {	
    return(this->document);
  }  

  void SetDocument(Document* d)
  {
    this->document = d;
  }
  friend int operator == (AbbrevEntry&, AbbrevEntry&);

  void WriteToStream(PStream*);
  void ReadFromStream(PStream* , Document* doc);
  unsigned int Enter();

  // functions called through "apply"
  void AddToInterface(unsigned int i, void*);

#ifndef NDEBUG
  void Dump(unsigned int i, void* f);
  static void DumpHeader(FILE* f);
#endif
};

#define T AbbrevEntry
#define TABLE BaseAbbrevTable
#define SEG BaseAbbrevTableSeg
#include "tabletem.h"

class AbbrevTable
  : public BaseAbbrevTable
{
public:
  char* GetAbbrevData(int index);
  void MakeAbbrev(char* name, char* abbrev, Document* doc);
  int GetAbbrevByName(char* name, Document* doc);
  void RemoveAbbrev(uword index);
  void WriteAbbrevsInDocument(PStream* , Document* doc); 
  void ReadAbbrevsInDocument(PStream* , Document* doc); 
};

extern AbbrevTable STATIC_NEAR GlobalAbbrevTable;

#endif /* ABBREVS_H */
#endif /* BW2_ABBREV */
