// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: again.cpp,v 3.3 2000/05/04 13:44:01 kudou Exp $
// Implement "again" processing

#include "pword.h"
#include "again.h"
#include "pmenus.h"
#ifndef _WIN32
#  include <memory.h>
#endif

// the text buffer is not meant to hold large things
#define MAX_AGAIN_INPUT_LEN 200

static sjis STATIC_NEAR input_buf[MAX_AGAIN_INPUT_LEN];
static int STATIC_NEAR input_buf_count = 0;

// static slots of class Again
AgainThing STATIC_NEAR Again::cur;
AgainThing STATIC_NEAR Again::prev;
int STATIC_NEAR Again::doing_again;

AgainThing::AgainThing()
{
  command_to_do_again = 0;
  command_for_other_direction = 0;
  for (int i=0; i<OTHER_INFO_COUNT; i++)
  {
    other_info[i] = 0;
  }
}

// public method(replace of constructor)
void
Again::init()
{
  doing_again = 0;
}

// the application calls this to advise a command which will perform an
// action "again" in the other direction
void
Again::ToDoAgainInOtherDirection(int foo)
{
  if (!doing_again)
  {
    cur.command_for_other_direction = foo;
  }
}

// the application calls this for things which can't be undone.  The
// previous againable action info is restored.
void
Again::CantDoAgain()
{
  cur = prev;
}

void
Again::SetAgain(int foo)
{
  doing_again = 0;
  prev = cur;
  cur.command_to_do_again = foo;
  cur.command_for_other_direction = foo;
  for (int i=0; i<AgainThing::OTHER_INFO_COUNT; i++)
  {
    cur.other_info[i] = 0;
  }
}

// the application calls SetInput when the user has input text to be
// remembered.
void
Again::SetInput(sjis* foo, int len)
{
  if (!doing_again && 0 < len)
  {
    if (cur.command_to_do_again != IDM_InputText)
    {
      input_buf_count = 0;
      cur.command_to_do_again = IDM_InputText;
      cur.command_for_other_direction = IDM_InputText;
    }
    if (MAX_AGAIN_INPUT_LEN < len)
    {
      foo += len - MAX_AGAIN_INPUT_LEN;
      len = MAX_AGAIN_INPUT_LEN;
    }
    int new_len = input_buf_count + len;
    if (MAX_AGAIN_INPUT_LEN < new_len)
    {
      int n = new_len - MAX_AGAIN_INPUT_LEN;
      input_buf_count -= n;
      memmove(&input_buf[0],
	       &input_buf[n], sizeof(input_buf[0]) * input_buf_count);
    }
    memcpy(&input_buf[input_buf_count], foo, sizeof(input_buf[0]) * len);
    input_buf_count += len;
  }
}

sjis* 
Again::GetInput(int& len)
{
  len = input_buf_count;
  return(input_buf);
}

// obNXy[X̏B
void
Again::BackInput()
{
  if (!doing_again
      && 0 < input_buf_count
      && prev.command_to_do_again == IDM_InputText)
  {
    cur = prev;
    --input_buf_count;
  }
}

// the application should call ClearInput when the user has taken some
// action that interrupts a "single" bit of text input
void
Again::ClearInput()
{
  doing_again = 0;
  input_buf_count = 0;
}

