// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: alist.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// array list class

#ifdef KUDOU_TEST

#include "pword.h"
#include "alist.h"
#include <stdlib.h>

//
// ArrayList class
//

// ex.)
//
// buf_size = 5
// top = 0; bot = 0;
// [ ]-[ ]-[ ]-[ ]-[ ]
//
// top = 0; bot = 1;
// [*]-[ ]-[ ]-[ ]-[ ]
//
// top = 0; bot = 2;
// [*]-[*]-[ ]-[ ]-[ ]
//
// top = 0; bot = 3;
// [*]-[*]-[*]-[ ]-[ ]
//
// top = 1; bot = 3;
// [ ]-[*]-[*]-[ ]-[ ]
//
// top = 0; bot = 5;
// [*]-[*]-[*]-[*]-[*]
//

const uword initial_size = 10;

ArrayList::ArrayList()
{
  buf = (void* (*)[]) new void*[initial_size];
  buf_size = initial_size;
  top = 0;
  bot = 0;
}

ArrayList::~ArrayList()
{
  delete(void*) buf;
}

void 
ArrayList::RExpandBuf(uword additional_size)
{
  // [1]-[2]-[3]
  //  |
  //  V
  // [1]-[2]-[3]-[ ]-[ ]
  uword new_size = buf_size + additional_size;
  void* (* new_buf)[] = (void* (*)[]) new void*[new_size];
  memcpy(new_buf, buf, buf_size * sizeof(void*));
  delete(void*) buf;
  buf = new_buf;
  buf_size = new_size; 
}

void 
ArrayList::LExpandBuf(uword additional_size)
{
  // [1]-[2]-[3]
  //  |
  //  V
  // [ ]-[ ]-[1]-[2]-[3]
  uword new_size = buf_size + additional_size;
  void* (* new_buf)[] = (void* (*)[]) new void*[new_size];
  memcpy(& ((*new_buf)[additional_size]), buf, buf_size * sizeof(void*));
  delete(void*) buf;
  buf = new_buf;
  buf_size = new_size; 
  top += additional_size;
  bot += additional_size;
}

void 
ArrayList::Push(void* data)
{
  if (top == 0) 
  {
    if (bot == buf_size) 
    {
      LExpandBuf();
    }
    else 
    {
      // shift right
      memmove(& ((*buf)[1]), & ((*buf)[0]), sizeof(void*) * bot);
      bot++;
      (*buf)[0] = data;
      return;
    }
  }
  (*buf)[--top] = data;
}

void* 
ArrayList::Pop()
{
  void* ret = (top == bot) ? 0 : (*buf)[top++];
  ShrinkBuf();
  return ret;
}

void 
ArrayList::Inject(void* data)
{
  if (bot == buf_size) 
  {
    if (top == 0) 
    {
      RExpandBuf();
    }
    else 
    {
      // shift left 
      memmove(& ((*buf)[top - 1]), & ((*buf)[top]), 
	       sizeof(void*) * (bot - top));
      top--;
      (*buf)[bot - 1] = data;
      return;
    }
  }
  (*buf)[bot++] = data;
}

void* 
ArrayList::Eject()
{
  void* ret = (top == bot) ? 0 : (*buf)[--bot];
  ShrinkBuf();
  return ret;
}

uword 
ArrayList::Number()
{
  return bot - top;
}

void* 
ArrayList::GetTopData()
{
  return(*buf)[top];
}

uword 
ArrayList::Search(void* data)
{
  for (uword i = top; i < bot; i++) 
  {
    if ((*buf)[i] == data) 
    {
      return i + 1;
    }
  }
  return 0;
}

void 
ArrayList::Delete(void* data)
{
  uword n = Search(data);
  if (n != 0) 
  {
    Delete(n);
  }
}

void 
ArrayList::Delete(uword n)
{
  if ((n < top) || (n >= bot)) 
  {
    // out of region
    return;
  }
  if (n == top) 
  {
    top++;
  }
  else if (n == bot - 1) 
  {
    bot--; 
  }
  else 
  {
    ////////////////////////////////////////////
    // Ex.)
    //
    // buf_size = 10;
    // top = 2; bot = 9;
    // n = 3
    // num = bot - top = 7;
    //
    //  0   1   2   3   4   5   6   7   8   9
    // [ ]-[ ]-[*]-[*]-[*]-[*]-[*]-[*]-[*]-[ ]
    //                 ^^^
    ////////////////////////////////////////////
    // if  n <= 7 / 2
    if (n <= (bot - top) / 2) 
    {
      // move [2-3] -> [3-4]
      memmove(& ((*buf)[top + 1]), & ((*buf)[top]), 
	       sizeof(void*) * (n - 1));
    }
    else 
    {
      // move [5-8] -> [4-7]
      memmove(& ((*buf)[top + n - 1]), & ((*buf)[top + n]), 
	       sizeof(void*) * (bot - top - n)); 
    }
  }
  ShrinkBuf();
}

void* 
ArrayList::Access(uword n)
{
  if (n > bot - top) 
  {
    return 0;
  }
  return(*buf)[top + n - 1];
}

void* 
ArrayList::operator [] (uword n)
{
  if (n + 1 > bot - top) 
  {
    return 0;
  }
  return(*buf)[top + n];
}

void 
ArrayList::Replace(uword n, void* data)
{
  if (n > bot - top) 
  {
    return;
  }
  (*buf)[top + n - 1] = data;
}

void 
ArrayList::Insert(uword prev, void* data)
{
  if (prev == 0) 
  {
    Push(data);
  }
  else if (prev == bot - top) 
  {
    Inject(data);
  }
  else 
  {
    for (;;) 
    {
      bool l_shift = False;
      bool r_shift = False;
      if (top != 0) 
      {                      // L free
	if (bot != buf_size) 
	{            // R free
	  // L & R free, calc minimun shift costs
	  if (prev < (bot - top) / 2) 
	  {
	    // L ward shift
	    l_shift = True;
	  }
	  else 
	  {
	    // R ward shift
	    r_shift = True;
	  }
	}
	else 
	{
	  // L ward shift
	  l_shift = True;
	}
      }
      else if (bot != buf_size) 
      {
	// R ward shift
	r_shift = True;
      }
      else 
      {
	// Buffer Fill, calc minimun Expansion costs
	if (prev < (bot - top) / 2) 
	{
	  // L Expansion is effective
	  LExpandBuf();
	}
	else 
	{
	  // R Expansion is effective
	  RExpandBuf();
	}
	// insertion will be done in the next loop
      }
      
      if (l_shift) 
      {
	// Do L Shift
	memmove(& ((*buf)[top - 1]), & ((*buf)[top]),
		 sizeof(void*) * prev);
	(*buf)[--top + prev] = data;
	return;
      }
      if (r_shift) 
      {
	// Do R Shift
	memmove(& ((*buf)[top + prev]), & ((*buf)[top + prev - 1]),
		 sizeof(void*) * (bot - top - prev));
	(*buf)[top + prev] = data;
	bot++;
	return;
      }
    }
  }
}

void 
ArrayList::Insert(void* prev, void* data)
{
  uword n = Search(prev);
  if (n != 0) 
  {
    Insert(n, data);
  }
}

void 
ArrayList::Clear()
{
  top = bot = buf_size / 2;
  ShrinkBuf();
}

#endif /* KUDOU_TEST */

