// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: allayout.cpp,v 3.3 1999/06/20 21:51:26 kudou Exp $
// class AllLayout
// ŃC[ŴAꂼ̕ŌŗL̕iŗ]̈j
//  FrameObjectBSŋʗ̈̃[ŃCAEgł̂
// gpB

#include "pword.h"
#include "pwordbas.h"
#include "document.h"
#include "docconte.h"
#include "fission.h"
#include "objectid.h"
#include "allayout.h"
#include "pagemap.h"

// constructor
AllLayout::AllLayout(CrossPoint* cp)
  : FrameObject(cp)
{
}

// destructor
AllLayout::~AllLayout()
{
  ;
}

// display fill object
void 
AllLayout::DisplayObject(VDisplay*)
{
  ;	// do nothing.
}

// get frame object
uword 
AllLayout::GetObjectID()
{
  return IDAllLayoutObject;
}

// duplicator
FrameObject* 
AllLayout::Duplicator(CrossPoint* cp)
{
  return new AllLayout(cp);
}

// size change
void 
AllLayout::ChangeSize()
{
  Iunit new_size_x = GetWidth();
  Iunit new_size_y = GetHeight();
  DocumentContent* doc = GetDocumentContent();
  if (doc != 0) 
  {
    uword page_map_size = doc->GetPageMapSize();
    for (uword n = 1; n <= page_map_size; n++) 
    {
      PageMap* pm = doc->GetPageMap(n);
      pm->ChangeLayoutSize(new_size_x, new_size_y);
    }
  }
}

DocumentContent* 
AllLayout::GetDocumentContent()
{
  for (Document* doc = PWordBase::GetFirstDocument(); 
       doc != 0; 
       doc = doc->GetNextDocument()) 
  {
    DocumentContent* doccon = doc->GetDocumentContent();
    if (doccon->GetAllLayout() == this) 
    {
      return doccon;
    }
  }
  return 0;
}

// get margin fission
void 
AllLayout::GetMarginFission(Fission** top, Fission** bottom,
			     Fission** left, Fission** right)
{
  CrossPoint* cp = GetCrossPoint();
  cp->GetCellFission(*top, *bottom, *left, *right);
}

