// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: ansidlg.cpp,v 3.3 1999/05/23 17:26:08 kudou Exp $
// class AnsiDialog

#include "pword.h"
#include "ansidlg.h"
#include "docedit.h"
#include "docwindo.h"
#include "mwindow.h"
#include "pref.h"
#include "pwordpre.h"
#include "screen.h"

#define NUM_X 16
#define NUM_Y 6
#define FIRST_CHAR_CODE 0xa0
#define NUM_CHARS	(NUM_X * NUM_Y)

#define XY_CHAR(x, y) (FIRST_CHAR_CODE + NUM_X * (y) + (x))

#define NO_MATCH_XY	(-1)

// Class AnsiDialog has only 1 instance.
static DWORD old_foreground;
static HDC dc = 0;
static HFONT old_font = 0;
static int button_width = 0;
static int button_height = 0;
static int old_bk_mode;
static int pushed_x = NO_MATCH_XY;
static int pushed_y = NO_MATCH_XY;
static int first_pushed_x;
static int first_pushed_y;
static int mouse_active_p = False;

static void NEAR
get_width_height(int ch, int* width, int* height)
{
  char buffer[2];
  buffer[0] = (char) ch;
  buffer[1] = '\0';
#ifdef _WIN32
  SIZE width_height;
  GetTextExtentPoint32(dc, buffer, 1, &width_height);
  *height = width_height.cy;
  *width = width_height.cx;
#else /* _WIN32 */
  DWORD width_height = GetTextExtent(dc, buffer, 1);
  *height = HIWORD(width_height);
  *width = LOWORD(width_height);
#endif
}

static DWORD NEAR
set_text_color(HDC dc, DWORD color)
{
  return(::SetTextColor(dc, color));
}

static HANDLE NEAR
select_object(HDC dc, HANDLE h)
{
  return(::SelectObject(dc, h));
}

static void NEAR
fill_rect(HDC dc, RECT* r, HBRUSH brush)
{
  ::FillRect(dc, r, brush);
}

static void NEAR
fill_brushed_rect(int x, int y, int width, int height, HBRUSH brush)
{
  RECT r;
  r.left = x;
  r.right = x + width;
  r.top = y;
  r.bottom = y + height;
  fill_rect(dc, &r, brush);
}

static void NEAR
fill_color_rect(int x, int y, int width, int height)
{
  fill_brushed_rect(x, y, width, height, Screen::black_brush);
}

static void NEAR
redisplay_button(int x, int y)
{
  char buffer[2];
  char ch = XY_CHAR(x, y);
  buffer[0] = ch;
  buffer[1] = '\0';
  int width;
  int height;
  get_width_height(ch, &width, &height);
  
  RECT out;
  int out_width = button_width - 1;
  int out_height = button_height - 1;
  out.left = button_width * x;
  out.right = out.left + out_width;
  out.top = button_height * y;
  out.bottom = out.top + out_height;
  
  RECT in;
  in.left = out.left + 2;
  in.right = out.right - 2;
  in.top = out.top + 2;
  in.bottom = out.bottom - 2;
  
  if (x == pushed_x && y == pushed_y)
  {
    set_text_color(dc, Screen::pushed_button_color);
    fill_rect(dc, &out, Screen::black_brush);
    set_text_color(dc, Screen::pushed_text_color);
  }
  else
  {
    set_text_color(dc, Screen::button_face_color);
    fill_rect(dc, &in, Screen::black_brush);
    set_text_color(dc, WHITE);
    fill_color_rect(out.left, out.top, out_width - 1, 1);
    fill_color_rect(out.left, out.top + 1, out_width - 2, 1);
    fill_color_rect(out.left, out.top, 1, out_height - 1);
    fill_color_rect(out.left + 1, out.top, 1, out_height - 2);
    HBRUSH brush = ::CreateSolidBrush(Screen::button_shadow_color);
    fill_brushed_rect(out.left, out.bottom - 2, out_width - 1, 1, brush);
    fill_brushed_rect(out.left, out.bottom - 1, out_width, 1, brush);
    fill_brushed_rect(out.right - 2, out.top + 1, 1, out_height - 1, brush);
    fill_brushed_rect(out.right - 1, out.top, 1, out_height, brush);
    ::DeleteObject(brush);
    set_text_color(dc, Screen::button_text_color);
  }

  ::TextOut(dc,
	     (in.left + in.right - width) / 2,
	     (in.top + in.bottom - height) / 2, buffer, 1);
  
  set_text_color(dc, BLACK);
  fill_color_rect(out.left, out.bottom, out_width + 1, 1);
  fill_color_rect(out.right, out.top, 1, out_height + 1);
}

static void NEAR
restore_dc()
{
  ::SetBkMode(dc, old_bk_mode);
  set_text_color(dc, old_foreground);
  select_object(dc, old_font);
}

static void NEAR
setup_dc()
{
  old_font = (HFONT)select_object(dc,
			    GetStockObject(Pref_ansi_var_font
					    ? ANSI_VAR_FONT
					    : ANSI_FIXED_FONT));
  old_foreground = set_text_color(dc, BLACK);
  old_bk_mode = ::SetBkMode(dc, TRANSPARENT);
}

// private method
void NEAR
AnsiDialog::drawing_epilogue()
{
  if (dc)
  {
    restore_dc();
    ReleaseDC(this->GetHandle(), dc);
    dc = 0;
  }
}

// private method
void NEAR
AnsiDialog::drawing_prologue()
{
  if (dc == 0)
  {
    dc = GetDC(this->GetHandle());
    setup_dc();
  }
}

// private method
void NEAR
AnsiDialog::update_button(int x, int y)
{
  this->drawing_prologue();
  redisplay_button(x, y);
  this->drawing_epilogue();
}

// private method
void NEAR
AnsiDialog::fit_size()
{
  this->drawing_prologue();
  int max_width = 0;
  int max_height = 0;
  for (int ch = FIRST_CHAR_CODE; ch < FIRST_CHAR_CODE + NUM_CHARS; ++ch)
  {
    int width;
    int height;
    get_width_height(ch, &width, &height);
    SET_MAX(max_width, width);
    SET_MAX(max_height, height);
  }
  button_width = max_width + 9;
  button_height = max_height + 9;
  this->drawing_epilogue();
  
  HWND handle = this->GetHandle();
  RECT in;
  RECT out;
  ::GetWindowRect(handle, &out);
  ::GetClientRect(handle, &in);

  MoveWindow(handle,
	      out.left,
	      out.top,
	      (button_width * NUM_X - 1
	       + ((out.right - out.left) - (in.right - in.left))),
	      (button_height * NUM_Y - 1
	       + ((out.bottom - out.top) - (in.bottom - in.top))),
	      False);
}

// public method
void
AnsiDialog::fit()
{
  this->fit_size();
  ::InvalidateRect(this->GetHandle(), NULL, True);
}

// private method
void NEAR
AnsiDialog::inactivate_mouse(int do_beep_p)
{
  if (mouse_active_p)
  {
    mouse_active_p = False;
    ::ReleaseCapture();
  }
  if (pushed_x != NO_MATCH_XY && pushed_y != NO_MATCH_XY)
  {
    int x = pushed_x;
    int y = pushed_y;
    pushed_x = NO_MATCH_XY;
    pushed_y = NO_MATCH_XY;
    this->update_button(x, y);
  }
  if (do_beep_p)
  {
    MessageBeep(0);
  }
}

static int
find_button_xy(LPARAM_T lParam, int* x_ret, int* y_ret)
{
#ifdef _WIN32
  POINT p;
  LPARAM_TO_POINT(lParam, p);
#else /* _WIN32 */
  POINT p = MAKEPOINT(lParam);
#endif /* _WIN32 */
  int found = True;
  int x = p.x / button_width;
  if (NUM_X <= (unsigned int) x)
  {
    found = False;
    x = NO_MATCH_XY;
  }
  *x_ret = x;
  int y = p.y / button_height;
  if (NUM_Y <= (unsigned int) y)
  {
    found = False;
    y = NO_MATCH_XY;
  }
  *y_ret = y;
  return(found);
}

// virtual method
LRESULT_T
AnsiDialog::WndProc(MSG_T message, WPARAM_T wParam, LPARAM_T lParam)
{
  static int kill_flag = False;
  HWND handle = this->GetHandle();
  if (handle)
  {
    switch (message)
    {
     case WM_DESTROY:
      this->SetHandle(0);
      break;
      
     case WM_CLOSE:
       // We don't want destroy window.
      this->Hide();
      return(1);
      
     case WM_MOUSEACTIVATE:
      return(MA_NOACTIVATE);
      
     case WM_NCACTIVATE:
      if (wParam == 0)
      {
	wParam = 1;
      }
      break;
      
     case WM_ACTIVATEAPP:
      kill_flag = (wParam == 0);
      DefWindowProc(WM_NCACTIVATE, wParam, 0);
      return(0);
      
     case WM_KILLFOCUS:
      if (kill_flag)
      {
	DefWindowProc(message, wParam, lParam);
	return(DefWindowProc(WM_NCACTIVATE, 0, 0));
      }
      break;
      
     case WM_SETFOCUS:
      PostMessage(main_window_handle, WM_SETFOCUS, (WPARAM_T)this->GetHandle(), 0);
      return(0);
      
     case WM_FONTCHANGE:
      this->fit();
      return(0);

     case WM_PAINT:
      {
         PAINTSTRUCT ps;
         ::BeginPaint(handle, &ps);
	 dc = ps.hdc;
	 setup_dc();
	 for (int y = 0; y < NUM_Y; ++y)
	 {
	   for (int x = 0; x < NUM_X; ++x)
	   {
	     redisplay_button(x, y);
	   }
	 }
	 restore_dc();
	 dc = 0;
         ::EndPaint(handle, &ps);
      }
      return(0);
      
     case WM_RBUTTONDBLCLK:
     case WM_RBUTTONDOWN:
      this->inactivate_mouse(True);
      break;
      
     case WM_LBUTTONDBLCLK:
     case WM_LBUTTONDOWN:
      if (mouse_active_p)
      {
	this->inactivate_mouse(True);
      }
      else if ((wParam & (MK_MBUTTON | MK_RBUTTON)) == 0
	       && find_button_xy(lParam, &first_pushed_x, &first_pushed_y))
      {
	::SetCapture(handle);
	mouse_active_p = True;
	pushed_x = first_pushed_x;
	pushed_y = first_pushed_y;
	this->update_button(pushed_x, pushed_y);
      }
      break;
      
     case WM_LBUTTONUP:
     case WM_MOUSEMOVE:
      if (mouse_active_p)
      {
	int x;
	int y;
	find_button_xy(lParam, &x, &y);
	if (x != first_pushed_x || y != first_pushed_y)
	{
	  x = NO_MATCH_XY;
	  y = NO_MATCH_XY;
	}
	if (x != pushed_x || y != pushed_y)
	{
	  int foo;
	  foo = x;
	  x = pushed_x;
	  pushed_x = foo;
	  foo = y;
	  y = pushed_y;
	  pushed_y = foo;
	  this->update_button(first_pushed_x, first_pushed_y);
	}
	if (message == WM_LBUTTONUP)
	{
	  x = pushed_x;
	  y = pushed_y;
	  this->inactivate_mouse(False);
	  if (x == first_pushed_x || y == first_pushed_y)
	  {
	    if (Selected_Document == NULL)
	    {
	      ::MessageBeep(0);
	    }
	    else
	    {
	      sjis ch = XY_CHAR(x, y);
	      Selected_Window->GetEditor() ->InsertText(&ch, 1);
	    }
	  }
	}
      }
      break;
    }
  }
  return(DefWindowProc(message, wParam, lParam));
}

// private method
void NEAR
AnsiDialog::make_up_window()
{
  static int firstp = True;
  if (firstp)
  {
    firstp = False;
    WNDCLASS window_class;
    memset(&window_class, 0, sizeof(window_class));
    window_class.lpszClassName = ANSI_DIALOG_CLASS_NAME;
    window_class.hInstance = PWordPresentation::hInstance;
    window_class.lpfnWndProc = fWndProc;
    window_class.cbWndExtra = DLGWINDOWEXTRA + sizeof(this);
    window_class.hCursor = ::LoadCursor(NULL, (char*) IDC_ARROW);
    window_class.hbrBackground = (HBRUSH)::GetStockObject(LTGRAY_BRUSH);
    RegisterClass(&window_class);
  }

  HWND handle = CreateDialog(PWordPresentation::hInstance,
			     ANSI_DIALOG_TEMPLATE_NAME,
			     main_window_handle, NULL);
  if (handle)
  {
    this->SetHandle(handle);
    SetPointer(handle, this, DLGWINDOWEXTRA);
    this->fit_size();
    this->center_window();
  }
}

// public method
void
AnsiDialog::Go()
{
  if (this->GetHandle() == 0)
  {
    this->make_up_window();
  }
  if (this->GetHandle())
  {
    this->Show();
    this->BringToTop();
  }
  else
  {
    MessageBeep(0);
  }
}
