// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: attman.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// attribute management common to both character
// and paragraph attributes

#include "pword.h"
#include "pmenus.h"
#include "attribut.h"
#include "atts.h"
#include "docedit.h"
#include "document.h"
#include "docconte.h"
#include "pundo.h"
#include "pwordbas.h"
#include "intlist.h"
#include "xstr.h"
#include "attman.h"

// ------------------------------------------------------------
// General Utilities

IntervalList*
AttMan::GetSelection()
{
  return GetEditor()->GetSelection();
}

void
AttMan::BitchAboutConflictingAtts()
{
  Issue(S_ConflictingAttsMsg, MB_OK | MB_ICONSTOP);
}

void
AttMan::ReportStyleRedefinition(unsigned int style)
{
  StatusOut(GetRedefinitionMessageString(),
	     GetStyleName(style));
}

word
AttMan::GetAttValue(unsigned int attcode)
{
  return ::GetAttValue(GetCurrentAtts(), attcode);
}


// ------------------------------------------------------------
// Callbacks invoked from Apply

attr
AttMan::_SetOne(attr old, int attcode, int attvalue)
{
  return ::ApplyAtt(old, attcode, attvalue);
}

// implement "Set Style" for one character.

attr
AttMan::_SetStyle(attr old, int, int attvalue)
{
  return ::ApplyStyle(old, attvalue);
}


// implement "Revert To Pure" 

attr
AttMan::_SetPureStyle(attr old, int, int)
{
  return ::PureStyle(old);
}

// this routine just set the attributes themselves.  It is used when setting
// paragraph character styles.

attr
AttMan::_SetDirect(attr, int, int attval)
{
  return attval;
}
