// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: attman.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// define AttMan class, superclass to EditCharAtts and
// EditParAtts.  This class represents common functionality between
// character and paragraph attribute manipulation.
 
#ifndef ATTMAN_H
#define ATTMAN_H

#include "pundo.h"

class AttMan
{
private:
  DocumentEdit* editor;
	
  // these are functions which must be defined independently
  // for EditParAtts and EditCharAtts.
  virtual char* GetRedefinitionMessageString() = 0;

protected:
  DocumentEdit* GetEditor() { return editor; }
  void ReportStyleRedefinition(unsigned int);
  IntervalList* GetSelection();
  static void BitchAboutConflictingAtts();

  virtual attr GetCurrentAtts() = 0;
  word GetAttValue(unsigned int);
  
  // callbacks
  static attr _SetStyle(attr old, int, int);
  static attr _SetPureStyle(attr old, int, int);
  static attr _SetOne(attr old, int, int);
  static attr _SetDirect(attr old, int, int);
  
public:
  AttMan(DocumentEdit* de)
  {
    editor = de;
  }
};

#endif /* ATTMAN_H */
