// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: attribut.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// outside interface to attribute management system

#ifndef ATTRIBUT_H
#define ATTRIBUT_H

// the AttSpecList structure holds a combination of attribute codes and
// values.  Sometimes arrays of them are used to pass around combinations
// of attribute values.

typedef struct
{
  int attcode;
  int attvalue;
} AttSpecList;

#include "abbrevs.h"
#include "atts.h"
#include "borders.h"
#include "derivs.h"
#include "fonts.h"
#include "marks.h"
#include "styles.h"

#ifdef BW2_ABBREV
AbbrevEntry& get_abbrev_entry(unsigned int i);
#endif /* BW2_ABBREV */
AttsEntry& get_atts_entry(unsigned int i);
BorderEntry& get_border_entry(unsigned int i);
DerivEntry& get_deriv_entry(unsigned int i);
FontEntry& get_font_entry(unsigned int i);
MarkEntry& get_mark_entry(unsigned int i);
StyleEntry& get_style_entry(unsigned int i);
attr ApplyAtt(attr org, int attcode, int attvalue);
attr ApplyAttList(attr org, AttSpecList* speclist);
attr ApplyStyle(attr atts, int style);
attr MakeNextParAtt(attr);
attr PureStyle(attr);
attr ReadCharAtt(PStream*);
attr get_default_attributes(Paragraph*);
char* GetStyleName(int style);
int* get_atts(attr);
int DefineCharStyle(char* name, attr atts);
int DefineParaStyle(char* name, attr atts);
int GetAttValue(attr attributes, int attcode);
int GetBaseStyle(attr);
int GetStyleAttValue(int style, int attcode);
int GetStyleType(uword s);
int RedefineCharStyle(unsigned int, attr atts);
int RedefineParaStyle(unsigned int, attr atts);
int StepTextSize(int, int);
void GetAttValueList(attr attributes, AttSpecList* speclist);
void InitAttributeSystem();
void MarkCookieConnections(attr);
void RegenerateAttributes();
void UnmarkCookieConnections();
void WriteCharAtt(PStream* , attr);

// Some aliases.

#define ReadParAtt ReadCharAtt
#define WriteParAtt WriteCharAtt

#define EndAttributeExport UnmarkCookieConnections
#define EndAttributeImport UnmarkCookieConnections
#define StartAttributeExport UnmarkCookieConnections
#define StartAttributeImport UnmarkCookieConnections

#ifndef NDEBUG
void AttStatusOut(attr a);
void DumpAtts();
#endif

// ------------------------------------------------------------
// CHARACTERS

enum CharAttCodes
{
  CA_zero_reserved=0,
  CA_facename,		// value points into facename table
  CA_facename2,		// kanji charset font
  CA_size,		// font size
  CA_delta_size,	// and increment/decrement thereto
  CA_bold,		// 1 or 0
  CA_italic,		// 1 or 0
  CA_subscript,		// neg=sub, pos=super, 1=normal, 2=very, 
  CA_compressed,				
  CA_unbreakable,
  CA_hidden,
  CA_lines,		// index to lines entry in att table
  CA_reserved_12,
  CA_strikeout,
  CA_tab,		// tab style(using enum TabStyle)
  CA_inverted,
};

enum TabStyle
{
  TAB_reserved_0 = 0,
  TAB_left,
  TAB_FIRST = TAB_left,
  TAB_right,
  TAB_center,
  TAB_decimal,
  TAB_LAST = TAB_decimal,
};

// ------------------------------------------------------------
// PARAGRAPHS

enum ParAttCodes
{
  PA_zero_reserved=0,
  PA_firstleftmargin, 
  PA_secondleftmargin,
  PA_rightmargin, 
  PA_alignment,
  PA_parspace,
  PA_linespace,
  PA_lines,		// pointer into att table table
  PA_nobreak,
  PA_placement,
  PA_charatt,		// points into att table
  PA_vertical_alignment,
  PA_tabsize,
  PA_unused_13,
  PA_unused_14,
  PA_unused_15,
};

enum Alignment
{
  AL_zero_reserved=0,
  AL_leftaligned,
  AL_FIRST = AL_leftaligned,
  AL_centered,
  AL_rightaligned,
  AL_flushright,
  AL_stretched,
  AL_LAST = AL_stretched
};

// We use this type for frame-alignment.  AL_vertical_zero_rezerved means
// to refer paragraph's alignment to keep beatword-1 compatibility. (konno)
enum VerticalAlignment
{
  AL_vertical_zero_reserved=0,
  AL_vertical_up,
  AL_vertical_FIRST = AL_vertical_up,
  AL_vertical_center,
  AL_vertical_down,
  AL_vertical_adjust,
  AL_vertical_LAST = AL_vertical_adjust,
};

// Check VerticalAlignment value is valid.  VA is evaluated multiple.
#define vertical_alignment_valid_p(va) \
((int) AL_vertical_FIRST <= (int) (va) && (int) (va) <= (int) AL_vertical_LAST)

// values held by the PA_placement option
enum Placement
{
  PL_none=1,
  PL_FIRST=PL_none,
  PL_frame=2,
  PL_page=3,
  PL_LAST = PL_page
};

#endif /* ATTRIBUT_H */
