// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: atts.h,v 3.4 2000/05/04 13:44:02 kudou Exp $
// AttsEntry is a class which defines attribute value sets, where
// each attribute has a value(or UNKNOWN).  These things are pointed to both
// in RATEntry's(entries in the resolved attribute table) and in
// ADSEntry's(entries in the attribute derivation source table).

#ifndef ATTS_H
#define ATTS_H

#include "generics.h"

class DerivEntry;
class RATEntry;

class AttsEntry
  : public GenericEntry
{
  friend class BaseAttsTable;
  
public:
  enum AttCodes
  {
#ifdef _WIN32
    // Next value should be a short int (attr) minimum number. (kudou)
    UNKNOWN = 0xffff8000,	// not set, not defined
#else /* _WIN32 */
    UNKNOWN = (int) 0x8000,	// not set, not defined
#endif /* _WIN32 */
    NUMATTS = 16,		// must be > #par atts and #char atts
    CHARSTYLE = 1,		// character style entry
    PARSTYLE = 2,		// paragraph style entry
  };
  
  int vals[NUMATTS];
  int type;			// one of xxxSTYLE constants above
  RATEntry* rat_entry;
  
public:
  AttsEntry();
  AttsEntry(int type);
  AttsEntry(AttsEntry&);	// copy constructor
  AttsEntry(DerivEntry&);	// construct based on derivation
  AttsEntry(int type, int*);	// construct from values
  
private:
  unsigned char NEAR GetHash();
  void NEAR Init();
public:
  int AllUnknown();
  unsigned int Enter();
  void CopyVals(AttsEntry&);
  void FillIn(AttsEntry&);
  void Mark();
  void Plug(DerivEntry&);
  void ReadFromStream(PStream*);
  void Subtract(AttsEntry&);
  void SubtractAny(AttsEntry&);
  void WriteToStream(PStream*);
#ifndef NDEBUG
  void Dump(unsigned int i, void*);
  static void DumpHeader(FILE* f);
#endif

public:
  friend int operator == (AttsEntry&, AttsEntry&);
};

// ------------------------------------------------------------
// TABLE

#define T AttsEntry
#define TABLE BaseAttsTable
#define SEG BaseAttsTableSeg
#define DO_READ_WRITE
#include "tabletem.h"

extern unsigned int DefaultCharAtts;
extern unsigned int DefaultParAtts;
extern unsigned int UnknownCharAtts;
extern unsigned int UnknownParAtts;

class AttsTable
  : public BaseAttsTable
{
public:
  void Init();
  void SetDefaultSize(int);
};

extern AttsTable STATIC_NEAR GlobalAttsTable;

#endif /* ATTS_H */
