// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: avllist.cpp,v 3.3 2000/05/03 12:18:32 kudou Exp $
// AVL-Tree list class
// This class is used for panel charactor code and panel mapping.
// 92/05/07 Split and modify AVL class from the Leaf Class Library

#ifndef AVL_TEST
#include "pword.h"
#else
#include "typedef.h"
#include <stdio.h>
#endif
#include "avllist.h"

// ------------------------------------------------------------
// class AvlListNode AVL-Tree ̃m[h

class AvlListNode 
{
  // vf
  void* item;
  
  // em[h
  AvlListNode* parent;
  
  // m[h
  AvlListNode* left;
  
  // Em[h
  AvlListNode* right;
  
  // ؂̍
  uword height;
  
public:
  // RXgN^
  NEAR AvlListNode(void* item, AvlListNode* parent = 0, 
		    AvlListNode* left = 0, AvlListNode* right = 0);
  
  // fXgN^
  ~AvlListNode() 
  { ; }
  
  // vf̎o
  void* GetItem() 
  { return item; }
  
  // vf̐ݒ
  void SetItem(void* item) 
  { AvlListNode::item = item; }
  
  // ؂̍̎o
  uword GetHeight() 
  { return height; }
  
  // em[h̎o
  AvlListNode* GetParent() 
  { return parent; }
  
  // em[h̃Zbg
  void SetParent(AvlListNode* parent) 
  { AvlListNode::parent = parent; }
  
  // m[h̎o
  AvlListNode* GetLeft() 
  { return left; }
  
  // m[h̃Zbg
  void SetLeft(AvlListNode* left) 
  { AvlListNode::left = left; }
  
  // Em[h̎o
  AvlListNode* GetRight() 
  { return right; }
  
  // Em[h̃Zbg
  void SetRight(AvlListNode* right) 
  { AvlListNode::right = right; }
  
  // m[hǂ
  bool IsLeft() 
  { 
    return(parent == 0) ? False : (parent->GetLeft() == this);
  }
  
  // Em[hǂ
  bool IsRight() 
  {
    return(parent == 0) ? False : (parent->GetRight() == this);
  }
  
  // ԍ̃m[h̎o
  AvlListNode* GetTreeLeft();
  
  // ԉẼm[h̎o
  AvlListNode* GetTreeRight();
  
  // ̃m[h̎o
  AvlListNode* GetPrev();
  
  // Õm[h̎o
  AvlListNode* GetNext();
  
  // m[h̗vfɂ錟
  AvlListNode* GetNode(void* item);
  
  // Tree  N Ԗڂ̃m[h𓾂
  AvlListNode* GetNode(uword n);
  
  // N͂
  AvlListNode* UnLink();
  
  // eƂ̃N؂Aق̃m[hȂ
  void ChangeParentLink(AvlListNode* new_node);
  
  // Q؂폜
  void DeleteTree();
  
  // [̃m[hP
  AvlListNode* GetLeafNode();
  
  // q̃m[hP
  AvlListNode* GetChildNode() 
  {
    return(left != 0) ? left : right;
  }
  // ̃m[h艺̖؂ɍ̕ω̂
  // ؂̃oXƂ
  void BalanceTree(AvlListNode** root);
  
  // ؂̍̍XV
  void UpdateTreeHeight();
  
private:
  // ]
  AvlListNode* Rotation();
  
  // Pd]
  AvlListNode* LeftSingleRotation();
  
  // Qd]
  AvlListNode* LeftDoubleRotation();
  
  // EPd]
  AvlListNode* RightSingleRotation();
  
  // EQd]
  AvlListNode* RightDoubleRotation();
  
public:
#ifdef AVL_TEST
  void ShowElement(uword level, void(* show) (void* elem));
#endif
};

NEAR
AvlListNode::AvlListNode(void* item, AvlListNode* parent,
			  AvlListNode* left, AvlListNode* right)
{
  AvlListNode::item = item;
  AvlListNode::parent = parent;
  AvlListNode::left = left;
  AvlListNode::right = right;
  AvlListNode::height = 1;
}

// ------------------------------------------------------------
// class AvlListNodeIterator C^[^

class AvlListNodeIterator
{
  // X^[gm[h
  AvlListNode* start;
  
  // ݂̃m[h
  AvlListNode* current;
  
public:
  // RXgN^
  NEAR AvlListNodeIterator(AvlListNode* top);
  
  // C^[^
  AvlListNode* NEAR operator() ();
  
  // ߂
  void Revert(AvlListNode* top) 
  {
    start = top;
    current = 0;
  }
};

// ------------------------------------------------------------
// class AvlListNodeIterator ̃\bh

NEAR
AvlListNodeIterator::AvlListNodeIterator(AvlListNode* top) 
{
  start = top;
  current = 0;
}

AvlListNode* NEAR
AvlListNodeIterator::operator() ()
{
  if (current == 0) 
  {
    if (start == 0) 
    {
      // C^[V͂łɏIĂ
      return 0;
    }
    // ŏ̃C^[V
    return current = start->GetTreeLeft();
  }
  if (current->GetRight() != 0) 
  {
    // Ẽm[h̃C^[V
    return current = current->GetRight()->GetTreeLeft();
  }
  if (current->IsLeft()) 
  {
    // ̃m[h̃C^[V͏I
    // eɂǂ
    return current = current->GetParent();
  }
  // EC^[V͏I
  AvlListNode* node;
  for (node = current;
       node != start;
       node = node->GetParent()) 
  {
    if (node->IsLeft()) 
    {
      return current = node->GetParent();
    }
  }
  // C^[VI
  return start = node = 0;
}

// ------------------------------------------------------------
// class AvlListNode ̃\bh

AvlListNode* 
AvlListNode::GetTreeLeft()
{
  if (left == 0) 
  {
    return this;
  }
  AvlListNode* node;
  for (node = left;
       node->GetLeft() != 0;
       node = node->GetLeft()) 
  {
    ;
  }
  return node;
}

AvlListNode* 
AvlListNode::GetTreeRight()
{
  if (right == 0) 
  {
    return this;
  }
  AvlListNode* node;
  for (node = right;
       node->GetRight() != 0;
       node = node->GetRight()) 
  {
    ;
  }
  return node;
}

AvlListNode* 
AvlListNode::GetPrev()
{
  //  Tree ̃`FbN
  if (left != 0) 
  {
    return left->GetTreeRight();
  }
  // ̃m[heɑ΂Em[h
  if (IsRight()) 
  {
    return GetParent();
  }
  // q̃m[heɑ΂ĉEm[hɂȂĂƂ܂őkA
  // ̃m[h̗vf𓾂
  for (AvlListNode* node = GetParent();
       node != 0;
       node = node->GetParent()) 
  {
    if (node->IsRight()) 
    {
      return node->GetParent();
    }
  }
  return 0;
}

AvlListNode* 
AvlListNode::GetNext()
{
  // E Tree ̃`FbN
  if (right != 0) 
  {
    return right->GetTreeLeft();
  }
  // ̃m[heɑ΂鍶m[h
  if (IsLeft()) 
  {
    return GetParent();
  }
  // q̃m[heɑ΂čm[hɂȂĂƂ܂őkA
  // ̃m[h̗vf𓾂
  for (AvlListNode* node = GetParent();
       node != 0;
       node = node->GetParent()) 
  {
    if (node->IsLeft()) 
    {
      return node->GetParent();
    }
  }
  return 0;
}

AvlListNode* 
AvlListNode::GetNode(void* item)
{
  AvlListNodeIterator ni(this);
  AvlListNode* node;
  while ((node = ni()) != 0) 
  {
    if (node->GetItem() == item) 
    {
      return node;
    }
  }
  return 0;
}

AvlListNode* 
AvlListNode::GetNode(uword n)
{
  AvlListNodeIterator ni(this);
  uword num = 0;
  AvlListNode* node;
  while ((node = ni()) != 0) 
  {
    if (++num == n) 
    {
      return node;
    }
  }
  return 0;
}

AvlListNode* 
AvlListNode::UnLink()
{
  if (left == 0) 
  {
    if (right == 0) 
    {
      ChangeParentLink(0);
      return 0;
    }
    else 
    {
      ChangeParentLink(right);
      right->SetParent(parent);
      return right;
    }
  }
  else if (right == 0) 
  {
    ChangeParentLink(left);
    left->SetParent(parent);
    return left;
  }
  else 
  {
    // left != 0 && right != 0
    if (left->right == 0) 
    {
      AvlListNode* node = left;
      ChangeParentLink(node);
      node->SetParent(parent);
      node->right = right;
      right->SetParent(node);
      return node;
    }
    if (right->left == 0) 
    {
      AvlListNode* node = right;
      ChangeParentLink(node);
      node->SetParent(parent);
      node->left = left;
      left->SetParent(node);
      return node;
    }
    AvlListNode* node = left->right->GetTreeRight();
    AvlListNode* update = node->GetParent();
    AvlListNode* node_l = node->left;
    node->ChangeParentLink(node_l);
    if (node_l) 
    {
      node_l->SetParent(update);
    }
    while (update != this) 
    {
      update->UpdateTreeHeight();
      update = update->GetParent();
    }
    ChangeParentLink(node);
    node->SetParent(parent);
    node->right = right;
    right->SetParent(node);
    node->left = left;
    left->SetParent(node);
    return node;
  }
}

void 
AvlListNode::ChangeParentLink(AvlListNode* new_node)
{
  if (parent != 0) 
  {
    if (parent->left == this) 
    {
      parent->left = new_node;
    }
    else if (parent->right == this) 
    {
      parent->right = new_node;
    }
  }
}

void 
AvlListNode::DeleteTree()
{
  for (AvlListNode* node = GetLeafNode();
       node != 0;
       node = GetLeafNode()) 
  {
    node->ChangeParentLink(0);
    delete node;
  }
  ChangeParentLink(0);
  delete this;
}

AvlListNode* 
AvlListNode::GetLeafNode()
{
  if (GetChildNode() == 0) 
  {
    return 0;
  }
  AvlListNode* node;
  for (node = GetChildNode();
       node->GetChildNode() != 0;
       node = node->GetChildNode()) 
  {
    ;
  }
  return node;
}

// suppress macro
#undef max
inline uword 
max(uword i, uword j)
{
  return(i > j) ? i : j;
}

inline uword 
diff(uword i, uword j)
{
  return(i > j) ? i - j : j - i;
}

void 
AvlListNode::BalanceTree(AvlListNode** root)
{
  // [gɌĖ؂̍XVȂ
  // oX`FbN
  for (AvlListNode* node = this;
       node != 0;
       node = node->GetParent()) 
  {
    uword left_height = (node->GetLeft() == 0) ? 0 : 
    node->GetLeft()->height;
    uword right_height = (node->GetRight() == 0) ? 0 : 
    node->GetRight()->height;
    uword new_height = max(left_height, right_height) + 1;
    uword diff_height = diff(left_height, right_height);
    if ((diff_height <= 1) && (new_height == node->height))
    {
      // oXĂ
      break;
    }
    node->height = new_height;
    if (diff_height > 1) 
    {
      // ]ăoX߂
      if (node == *root) 
      {
	*root = node = node->Rotation();
      }
      else 
      {
	node = node->Rotation();
      }
    }
  }
}

AvlListNode* 
AvlListNode::Rotation()
{
  uword ll = (GetLeft() == 0) ? 0 : 
  ((GetLeft()->GetLeft() == 0) ? 0 : 
   GetLeft()->GetLeft()->height);
  uword lr = (GetLeft() == 0) ? 0 : 
  ((GetLeft()->GetRight() == 0) ? 0 : 
   GetLeft()->GetRight()->height);
  uword rl = (GetRight() == 0) ? 0 :
  ((GetRight()->GetLeft() == 0) ? 0 : 
   GetRight()->GetLeft()->height);
  uword rr = (GetRight() == 0) ? 0 :
  ((GetRight()->GetRight() == 0) ? 0 : 
   GetRight()->GetRight()->height);
  uword max_height = max(max(ll, lr), max(rl, rr));
  if (max_height == ll) 
  {
    return LeftSingleRotation();
  }
  else if (max_height == lr) 
  {
    return LeftDoubleRotation();
  }
  else if (max_height == rl) 
  {
    return RightDoubleRotation();
  }
  else 
  {
    return RightSingleRotation();
  }
}

AvlListNode* 
AvlListNode::LeftSingleRotation()
{
  AvlListNode* parent = GetParent();
  AvlListNode* l  = GetLeft();
  AvlListNode* lr = l->GetRight();
  
  this->ChangeParentLink(l);
  l->SetParent(parent);
  
  l->SetRight(this);
  this->SetParent(l);
  
  this->SetLeft(lr);
  if (lr != 0) 
  {
    lr->SetParent(this);
  }
  
  this->UpdateTreeHeight();
  l->UpdateTreeHeight();
  
  return l;
}

AvlListNode* 
AvlListNode::LeftDoubleRotation()
{
  AvlListNode* parent = GetParent();
  AvlListNode* l = GetLeft();
  AvlListNode* lr = l->GetRight();
  AvlListNode* lrl = lr->GetLeft();
  AvlListNode* lrr = lr->GetRight();
  
  this->ChangeParentLink(lr);
  lr->SetParent(parent);
  
  lr->SetLeft(l);
  l->SetParent(lr);
  
  lr->SetRight(this);
  this->SetParent(lr);
  
  l->SetRight(lrl);
  if (lrl != 0) 
  {
    lrl->SetParent(l);
  }
  
  this->SetLeft(lrr);
  if (lrr != 0) 
  {
    lrr->SetParent(this);
  }
  
  l->UpdateTreeHeight();
  this->UpdateTreeHeight();
  lr->UpdateTreeHeight();
  
  return lr;
}

AvlListNode* 
AvlListNode::RightSingleRotation()
{
  AvlListNode* parent = GetParent();
  AvlListNode* r  = GetRight();
  AvlListNode* rl = r->GetLeft();
  
  this->ChangeParentLink(r);
  r->SetParent(parent);
  
  r->SetLeft(this);
  this->SetParent(r);
  
  this->SetRight(rl);
  if (rl != 0) 
  {
    rl->SetParent(this);
  }
  
  this->UpdateTreeHeight();
  r->UpdateTreeHeight();
  
  return r;
}

AvlListNode* 
AvlListNode::RightDoubleRotation()
{
  AvlListNode* parent = GetParent();
  AvlListNode* r = GetRight();
  AvlListNode* rl = r->GetLeft();
  AvlListNode* rll = rl->GetLeft();
  AvlListNode* rlr = rl->GetRight();
  
  this->ChangeParentLink(rl);
  rl->SetParent(parent);
  
  rl->SetLeft(this);
  this->SetParent(rl);
  
  rl->SetRight(r);
  r->SetParent(rl);
  
  this->SetRight(rll);
  if (rll != 0) 
  {
    rll->SetParent(this);
  }
  
  r->SetLeft(rlr);
  if (rlr != 0) 
  {
    rlr->SetParent(r);
  }
  
  r->UpdateTreeHeight();
  this->UpdateTreeHeight();
  rl->UpdateTreeHeight();
  
  return rl;
}

// ؂̍̍XV
void 
AvlListNode::UpdateTreeHeight()
{
  uword right = (GetRight() == 0) ? 0 : GetRight()->height;
  uword left  = (GetLeft() == 0) ? 0 : GetLeft()->height;
  height = max(right, left) + 1;
}

#ifdef AVL_TEST
void 
AvlListNode::ShowElement(uword level, void(* show) (void* elem))
{
  if (level == 0) 
  {
    printf("\n");
  }
  // show right node
  if (GetRight() != 0) 
  {
    GetRight()->ShowElement(level + 1, show);
  }
  
  // show this node
#if 1
  printf(" (%d)", height);
#else
  printf("%p H:%2d P:%p L:%p R:%p", this, height, GetParent(), GetLeft(), GetRight());
#endif
  for (uword i = 0; i < level; i++) 
  {
    printf("   ");
  }
  if (GetParent() == 0) 
  {
    printf("=");
  }
  else if (GetParent()->GetLeft() == this) 
  {
    printf("\\");
  }
  else if (GetParent()->GetRight() == this) 
  {
    printf("/");
  }
  (*show) (GetItem());
  
  // show left node
  if (GetLeft() != 0) 
  {
    GetLeft()->ShowElement(level + 1, show);
  }
}
#endif

// ------------------------------------------------------------
// class AvlList ̃\bh

AvlList::AvlList()
{
  root = 0;
}

AvlList::AvlList(AvlList& l)
{
  root = 0;
  operator = (l);
}

AvlList::~AvlList()
{
  Clear();
}

void 
AvlList::operator = (AvlList& l)
{
  Clear();
  if (((AvlList&)l).root != 0) 
  {
    AvlListNodeIterator tpni(((AvlList&)l).root);
    AvlListNode* node;
    while ((node = tpni()) != 0) 
    {
      Inject(node->GetItem());
    }
  }
}

bool 
AvlList::IsEmpty()
{
  return(root == 0);
}

uword 
AvlList::Number()
{
  AvlListNodeIterator ni(root);
  uword num = 0;
  while (ni() != 0) 
  {
    num++;
  }
  return num;
}

void* 
AvlList::Access(uword n)
{
  if (root == 0) 
  {
    return 0;
  }
  AvlListNode* node = root->GetNode(n);
  return(node != 0) ? node->GetItem() : 0;
}

void* 
AvlList::operator [] (uword n)
{
  return Access(n + 1);
}

#if 0
void* 
AvlList::Prev(void* item)
{
  AvlListNode* node;
  if ((root == 0) ||
      ((node = root->GetNode(item)) == 0)) 
  {
    return 0;
  }
  if ((node = node->GetPrev()) != 0) 
  {
    return node->GetItem();
  }
  return 0;
}
#endif

#if 0
void* 
AvlList::Next(void* item)
{
  AvlListNode* node;
  if ((root == 0) ||
      ((node = root->GetNode(item)) == 0)) 
  {
    return 0;
  }
  if ((node = node->GetNext()) != 0) 
  {
    return node->GetItem();
  }
  return 0;
}
#endif

#if 0
void* 
AvlList::Head()
{
  return(root == 0) ? 0 : root->GetTreeLeft()->GetItem();
}
#endif

#if 0
void* 
AvlList::Tail()
{
  return(root == 0) ? 0 : root->GetTreeRight()->GetItem();
}
#endif

#if 0
void* 
AvlList::Pop()
{
  void* item = 0;
  if (root != 0) 
  {
    AvlListNode* node = root->GetTreeLeft();
    item = node->GetItem();
    DeleteNode(node);
  }
  return item;
}
#endif

#if 0
void* 
AvlList::Eject()
{
  void* item = 0;
  if (root != 0) 
  {
    AvlListNode* node = root->GetTreeRight();
    item = node->GetItem();
    DeleteNode(node);
  }
  return item;
}
#endif

#if 0
void 
AvlList::Delete(void* pos)
{
  if (root != 0) 
  {
    DeleteNode(root->GetNode(pos));
  }
}
#endif

#if 0
void 
AvlList::Delete(uword pos)
{
  if (root != 0) 
  {
    DeleteNode(root->GetNode(pos));
  }
}
#endif

void 
AvlList::Clear()
{
  if (root != 0) 
  {
    root->DeleteTree();
    root = 0;
  }
}

#if 0
void 
AvlList::ExchangeItem(void* item, uword pos)
{
  if (root != 0) 
  {
    AvlListNode* node = root->GetNode(pos);
    node->SetItem(item);
  }
}
#endif

#if 0
void 
AvlList::ExchangeItem(void* item, void* pos)
{
  if (root != 0) 
  {
    AvlListNode* node = root->GetNode(pos);
    node->SetItem(item);
  }
}
#endif

#if 0
void 
AvlList::SwapItem(void* i1, void* i2)
{
  if (root != 0) 
  {
    AvlListNode* node1 = root->GetNode(i1);
    AvlListNode* node2 = root->GetNode(i2);
    void* item = node1->GetItem();
    node1->SetItem(node2->GetItem());
    node2->SetItem(item);
  }
}
#endif

#if 0
void 
AvlList::SwapItem(uword n1, uword n2)
{
  if (root != 0) 
  {
    AvlListNode* node1 = root->GetNode(n1);
    AvlListNode* node2 = root->GetNode(n2);
    void* item = node1->GetItem();
    node1->SetItem(node2->GetItem());
    node2->SetItem(item);
  }
}
#endif

#if 0
void 
AvlList::Push(void* item)
{
  if (root == 0) 
  {
    root = new AvlListNode(item);
  }
  else 
  {
    AvlListNode* node = root->GetTreeLeft();
    node->SetLeft(new AvlListNode(item, node));
    node->BalanceTree(&root);
  }
}
#endif

void 
AvlList::Inject(void* item)
{
  if (root == 0) 
  {
    root = new AvlListNode(item);
  }
  else 
  {
    AvlListNode* node = root->GetTreeRight();
    node->SetRight(new AvlListNode(item, node));
    node->BalanceTree(&root);
  }
}

#if 0
void 
AvlList::InsertBefor (void* item, uword pos)
{
  if (root != 0) 
  {
    AvlListNode* node = root->GetNode(pos);
    if (node->GetLeft() != 0) 
    {
      node = node->GetLeft()->GetTreeRight();
      node->SetRight(new AvlListNode(item, node));
    }
    else 
    {
      node->SetLeft(new AvlListNode(item, node));
    }
    node->BalanceTree(&root);
  }
}
#endif

#if 0
void 
AvlList::InsertBefor (void* item, void* pos)
{
  if (root != 0) 
  {
    AvlListNode* node = root->GetNode(pos);
    if (node->GetLeft() != 0) 
    {
      node = node->GetLeft()->GetTreeRight();
      node->SetRight(new AvlListNode(item, node));
    }
    else 
    {
      node->SetLeft(new AvlListNode(item, node));
    }
    node->BalanceTree(&root);
  }
}
#endif

#if 0
void 
AvlList::InsertAfter(void* item, uword pos)
{
  if (root != 0) 
  {
    AvlListNode* node = root->GetNode(pos);
    if (node->GetRight() != 0) 
    {
      node = node->GetRight()->GetTreeLeft();
      node->SetLeft(new AvlListNode(item, node));
    }
    else 
    {
      node->SetRight(new AvlListNode(item, node));
    }
    node->BalanceTree(&root);
  }
}
#endif

#if 0
void 
AvlList::InsertAfter(void* item, void* pos)
{
  if (root != 0) 
  {
    AvlListNode* node = root->GetNode(pos);
    if (node->GetRight() != 0) 
    {
      node = node->GetRight()->GetTreeLeft();
      node->SetLeft(new AvlListNode(item, node));
    }
    else 
    {
      node->SetRight(new AvlListNode(item, node));
    }
    node->BalanceTree(&root);
  }
}
#endif

void 
AvlList::DeleteNode(AvlListNode* node)
{
  if ((root != 0) && (node != 0)) 
  {
    AvlListNode* parent = node->GetParent();
    AvlListNode* new_node = node->UnLink();
    if (new_node != 0) 
    {
      new_node->UpdateTreeHeight();
    }
    if (root == node) 
    {
      root = new_node;
    }
    delete node;
    if (parent != 0) 
    {
      parent->BalanceTree(&root);
    }
  }
}

#ifdef AVL_TEST
void 
AvlList::ShowElement(void(* show) (void*))
{
  if (root != 0) 
  {
    root->ShowElement(0, show);
  }
}
#endif

// ------------------------------------------------------------
// class AvlListIterator ̃\bh

AvlListIterator::AvlListIterator(AvlList* l)
{
  tpni = new AvlListNodeIterator(l->root);
}

AvlListIterator::AvlListIterator(AvlList& l)
{
  tpni = new AvlListNodeIterator(l.root);
}

AvlListIterator::AvlListIterator(AvlSearch* l)
{
  tpni = new AvlListNodeIterator(l->root);
}

AvlListIterator::~AvlListIterator()
{
  delete tpni;
}

void* 
AvlListIterator::operator() ()
{
  AvlListNode* node = (*tpni) ();
  return(node != 0) ? node->GetItem() : 0;
}

// ------------------------------------------------------------
// class AvlSearch ̃\bh

AvlSearch::AvlSearch
#ifdef MSC7_FUNARG_BUG
(void* compare, void* key_compare)
#else
  (Comp(*compare) (void* , void*), Comp(*key_compare) (void* , void*))
#endif
{
  AvlSearch::compare = (Comp(*) (void* , void*)) compare;
  AvlSearch::key_compare = (Comp(*) (void* , void*)) key_compare;
}

AvlSearch::~AvlSearch()
{
}

void 
AvlSearch::Add(void* elem)
{
  AvlListNode* node = root;
  while (node != 0) 
  {
    switch (Compare(node->GetItem(), elem)) 
    {
     case Small:
      if (node->GetRight() == 0) 
      {
	node->SetRight(new AvlListNode(elem, node));
	node->BalanceTree(&root);
	return;
      }
      node = node->GetRight();
      break;
     case Equal:
      // łɓo^ς
      return;
     case Big:
      if (node->GetLeft() == 0) 
      {
	node->SetLeft(new AvlListNode(elem, node));
	node->BalanceTree(&root);
	return;
      }
      node = node->GetLeft();
      break;
     default:
      node = 0;
    }
  }
  root = new AvlListNode(elem);
}

#if 0
void 
AvlSearch::Remove(void* elem)
{
  AvlListNode* node = root;
  while (node != 0) 
  {
    switch (KeyCompare(node->GetItem(), elem)) 
    {
     case Small:
      node = node->GetRight();
      break;
     case Equal:
      // find
      DeleteNode(node);
      return;
     case Big:
      node = node->GetLeft();
      break;
     default:
      node = 0;
    }
  }
}
#endif

void 
AvlSearch::KeyRemove(void* key)
{
  AvlListNode* node = root;
  while (node != 0) 
  {
    switch (KeyCompare(node->GetItem(), key)) 
    {
     case Small:
      node = node->GetRight();
      break;
     case Equal:
      // find
      DeleteNode(node);
      return;
     case Big:
      node = node->GetLeft();
      break;
     default:
      node = 0;
    }
  }
}

void* 
AvlSearch::Search(void* key)
{
  AvlListNode* node = root;
  while (node != 0) 
  {
    switch (KeyCompare(node->GetItem(), key)) 
    {
     case Small:
      node = node->GetRight();
      break;
     case Equal:
      // find
      return node->GetItem();
     case Big:
      node = node->GetLeft();
      break;
     default:
      node = 0;
    }
  }
  return 0;
}
