// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: avllist.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// AVL-Tree list class
// This class is used for panel charactor code and panel mapping.
// 92/05/07 Split and modify AVL class from the Leaf Class Library

#ifndef AVLLIST_H
#define AVLLIST_H

class AvlListNode;
class AvlListNodeIterator;
class AvlSearch;

class AvlList 
{
  friend class AvlListIterator;
protected:
  // Q؂̃[g
  AvlListNode* root;
  
  // m[h̍폜
  void DeleteNode(AvlListNode* node);
  
public:
  // RXgN^
  AvlList();
  
  // Rs[RXgN^
  AvlList(AvlList& l);
  
  // fXgN^
  ~AvlList();
  
  // ATCg
  void operator = (AvlList& l);
  
  // 񂪋󂩂ǂ
  // return            : False: vf
  bool IsEmpty();
  
  // ̗vf𓾂
  // return            : vf̐
  uword Number();
  
  // vf̎Q
  // n                 : ʒuiP`j
  // return            : vfAG[ȂOԂ
  void* Access(uword n);
  
  // vf̔zIȎQ
  // n                 : CfbNXiO`j
  // return            : vfAG[ȂOԂ
  void* operator [] (uword n);
  
  // PO̗vf𓾂
  // item              : ̗vf̂PO
  // return            : O̗vfAG[ȂOԂ
  void* Prev(void* item) ;
  
  // P̗vf𓾂
  // item              : ̗vf̂P
  // return            : P̗vfAG[ȂOԂ
  void* Next(void* item);
  
  // ̐擪vf𓾂
  // return            : 擪vfAG[ȂOԂ
  void* Head();
  
  // ̖vf𓾂
  // return            : vfAG[ȂOԂ
  void* Tail();
  
  // ̐擪ɗvf
  // item              : }vf
  void Push(void* item);
  
  // ̐擪̗vfO
  // return            : oꂽvf
  void* Pop();
  
  // ̖ɗvf
  // item              : }vf
  void Inject(void* item) ;
  
  // ̖̗vfO
  // return            : oꂽvf
  void* Eject();
  
  // O}
  // item              : }vf
  // pos               : }ʒuiP`j
  void InsertBefor (void* item, uword pos);
  
  // O}
  // item              : }vf
  // pos               : ̗vf̑Oɑ}
  void InsertBefor (void* item, void* pos);
  
  // }
  // item              : }vf
  // pos               : }ʒuiP`j
  void InsertAfter(void* item, uword pos);
  
  // }
  // item              : }vf
  // pos               : ̗vf̌ɑ}
  void InsertAfter(void* item, void* pos);
  
  // 폜
  // item              : 폜vf
  void Delete(void* item);
  
  // 폜
  // pos               : ̈ʒu̗vf폜
  void Delete(uword pos);
  
  // ׂĂ̗vf̍폜
  void Clear();
  
  // vf̕ύX
  // item              : Vvf̒l
  // pos               : ύXvf
  void ExchangeItem(void* item, void* pos);
  
  // vf̕ύX
  // item              : Vvf̒l
  // pos               : ύXʒuiP`j
  void ExchangeItem(void* item, uword pos);
  
  // vf̌
  // i1, i2            : vf
  void SwapItem(void* i1, void* i2);
  
  // vf̌
  // n1, n2            : ʒu
  void SwapItem(uword n1, uword n2);
  
#ifdef AVL_TEST
  // fobN\
  void ShowElement(void(* show) (void*));
#endif
};

class AvlListIterator 
{
  AvlListNodeIterator* tpni;
  
public:
  // RXgN^
  // l                 : C^[g
  AvlListIterator(AvlList* l);
  
  // RXgN^
  // l                 : C^[g
  AvlListIterator(AvlList& l);
  
  // RXgN^
  // l                 : C^[g
  AvlListIterator(AvlSearch* l);
  
  // fXgN^
  ~AvlListIterator();
  
  // C^[^AXɗ̗vfԂ
  // C^[gǏĂяoʂ͕s
  // return            : ̗vfAOԂ̏I
  void* operator() ();
};

class AvlSearch
  : private AvlList
{
  friend class AvlListIterator;
public:
  // r
  enum Comp 
  {
    Small = -1, // 
    Equal = 0, 	// 
    Big = 1, 	// 傫
  };
#ifdef MSC7_FUNARG_BUG
  AvlSearch(void *, void *);
#else
  AvlSearch(Comp(*) (void *, void *), Comp(*) (void *, void *));
#endif
  
private:
  // IuWFNgrp֐
  // Comp	: Small  elem1 < elem2
  //           : Equal  elem1 == elem2
  //           : Big    elem1 > elem2
  Comp(* compare) (void* elem1, void* elem2);
  
  // L[rp֐
  // Comp	: Small  elem->key < key
  //           : Equal  elem->key == key
  //           : Big    elem->key > key
  Comp(* key_compare) (void* elem, void* key);
  
protected:
  // r
  Comp Compare(void* elem1, void* elem2)
  {
    return(*compare) (elem1, elem2);
  }
  
  // L[r
  Comp KeyCompare(void* elem, void* key)
  {
    return(*key_compare) (elem, key);
  }
  
public:
#if (0)
  // RXgN^
  AvlSearch(Comp(* compare) (void*, void*), 
	     Comp(* key_compare) (void*, void*));
#endif
  
  // fXgN^
  ~AvlSearch();
  
  // vf̒ǉ
  void Add(void* elem);
  
  // vf̍폜
  void Remove(void* elem);
  
  // L[ɂvf̍폜
  void KeyRemove(void* key);
  
  // L[T[`
  void* Search(void* key);
  
  AvlList::IsEmpty;
  AvlList::Number;
  AvlList::Clear;
  
#ifdef AVL_TEST
  void ShowElement(void(* show) (void*)) 
  {
    AvlList::ShowElement(show); 
  }
#endif
};

#endif /* AVLLIST_H */
