// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: base.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// define BaseIntervalList class, for lists of intervals
// and BaseInterval

#ifndef BASE_H
#define BASE_H

class BaseInterval;
class BaseIntervalList;
class BaseIntervalListTraversor;
class BoundIntervalList;

class BaseInterval
{
  friend class BaseIntervalList;
  friend class BaseIntervalListTraversor;
  friend class BoundIntervalList;
  friend class IntervalList;
  friend class PUndoItem;
  
protected:
  BaseInterval* next;
  
public:
  BaseInterval() { next=0; }
  virtual ~BaseInterval() { }
  
  BaseInterval* GetNext()
  {
    return next;
  }
  
  virtual int EQ(BaseInterval&) = 0;
};

class BaseIntervalList
{
  friend class BaseIntervalListTraversor;
  friend class BoundIntervalList;
  friend class IntervalList;
  friend class PUndoItem;
  
protected:  
  BaseInterval* head;
  
  void Init();
  virtual BaseInterval* NewMember(BaseInterval*) = 0;
  
public:
  // construct an empty base interval list
  BaseIntervalList();

  // create a base interval list with a single interval
  BaseIntervalList(BaseInterval*);
  
  ~BaseIntervalList();
  
  // copy a base interval list, using the virtual "NewMember" method
  // to copy each interval
  void Copy(BaseIntervalList* il);
  
  // add intervals to the base interval list
  void AddIntervalAtTail(BaseInterval*);
  void AddIntervalAtHead(BaseInterval*);
  
  void DeleteInterval(BaseInterval*);
  void DeleteSecondaryIntervals();
  void Collapse();
  void CutOffTail();
  void CutOffHead();
  BaseInterval* GetHead() { return head; }
  void Cycle(int direction);
  bool SingleP();
  int Count();
  
  // compare intervals for equality, by calling the virtual EQ
  // function defined on BaseInterval for each member
  int EQ(BaseIntervalList&);
  void Apply(void(BaseInterval::*) ());
  void Reverse();
};

class BaseIntervalListTraversor
{
  BaseInterval* cur;
public:
  BaseIntervalListTraversor(BaseIntervalList* il);
  BaseIntervalListTraversor(BaseInterval* i);
  ~BaseIntervalListTraversor() {}
  BaseInterval* GetNext();
  BaseInterval* operator++ () { return GetNext(); }
};

#endif /* BASE_H */
