// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: bitstrin.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// Bit String
// rbg̃Xg[\NX

#include "pword.h"
#include "pstreams.h"
#include "bitstrin.h"

const udword unit = 32;

// get buffer size
udword 
BitString::GetBufferSize()
{
  return size / unit + 1;
}

// constructor
BitString::BitString(udword size)
{
  BitString::size = size;
  uword buf_size = (uword)GetBufferSize();
  buf = new bit32[buf_size];
  
  // 0 clear
  for (uword i = 0; i < buf_size; i++) 
  {
    buf[i] = 0L;
  }
}

// destructor
BitString::~BitString()
{
  delete buf;
}

static udword mask_table[32] = 
{
  0x00000001L, 0x00000002L, 0x00000004L, 0x00000008L,
  0x00000010L, 0x00000020L, 0x00000040L, 0x00000080L,
  0x00000100L, 0x00000200L, 0x00000400L, 0x00000800L,
  0x00001000L, 0x00002000L, 0x00004000L, 0x00008000L,
  0x00010000L, 0x00020000L, 0x00040000L, 0x00080000L,
  0x00100000L, 0x00200000L, 0x00400000L, 0x00800000L,
  0x01000000L, 0x02000000L, 0x04000000L, 0x08000000L,
  0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L,
};

// bit check
bool 
BitString::operator [] (udword n)
{
  assert(n <= size);
  return(mask_table[ (uword) (n % unit)] & buf[ (uword) (n / unit)])
  ? True : False;
}

// get least clear bit
udword 
BitString::GetLeastClearBit()
{
  udword bufsize = GetBufferSize();
  for (udword n = 0; n < bufsize; n++) 
  {
    if (buf[ (uword)n] != 0xffffffffL) 
    {
      for (udword i = 0; i <= 32L; i++) 
      {
	if (! (*this)[i + n * 32L]) 
	{
	  return i + n * 32L;
	}
      }
      assert(False);
    }
  }
  return size + 1;
}

// set bit
void 
BitString::Set(udword n, bool b)
{
  assert(n <= size);
  if (b == False) 
  {
    // bit clear
    buf[ (uword) (n / unit)] &= ~mask_table[ (uword) (n % unit)];
  }
  else 
  {
    // bit set
    buf[ (uword) (n / unit)] |= mask_table[ (uword) (n % unit)];
  }
}

// set all
void 
BitString::SetAll(bool b)
{
  udword pattern = (b == False) ? 0 : 0xffffffffL;
  udword bufsize = GetBufferSize();
  for (udword n = 0; n < bufsize; n++) 
  {
    buf[ (uword)n] = pattern;
  }
}

// write to stream
void
BitString::WriteToStream(PStream* stream)
{
  stream->OutULong(size);
  CHECK;
  
  stream->Out(buf, (uword) (GetBufferSize() * sizeof(bit32)));
  CHECK;
}

// read from stream
BitString*
BitString::ReadFromStream(PStream* stream)
{
  udword size = stream->InULong();
  CHECK 0;
  BitString* bs = new BitString(size);
  stream->In(bs->buf, (uword) (bs->GetBufferSize() * sizeof(bit32)));
  if (stream->GetError() != SE_NOERROR)
  {
    delete bs;
    bs = NULL;
  }
  return(bs);
}
