// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: bitstrin.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// Bit String

#ifndef BITSTRING_H
#define BITSTRING_H

typedef udword bit32;		// unsigned 32 bit type

class BitString
{
  // bit string size(bit number)
  udword size;
  
  // bit buffer
  bit32* buf;
  
  // get buffer size
  udword GetBufferSize();
  
public:
  // constructor
  BitString(udword size);
  
  // destructor
  ~BitString();
  
  // bit check
  bool operator [] (udword n);
  
  // set bit
  void Set(udword n, bool b);
  
  // set all
  void SetAll(bool b);
  
  // get bit size
  udword GetSize() 
  { return size; }
  
  // get least clear bit
  udword GetLeastClearBit();
  
  // write to stream
  void WriteToStream(PStream* stream);
  
  // read from stream
  static BitString* ReadFromStream(PStream* stream);
};

#endif /* BITSTRING_H */
