// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: border.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// definitions for class BorderDialog.
// This is a superclass for four types of border dialogs:
// paragraphs, characters, lines, and frames.

#ifndef BORDERDIALOG_H
#define BORDERDIALOG_H

#include "dlg.h"
#include "borderli.h"
#include "editfram.h"

class BorderDialog 
  : public NoKanjiModalDialog
{
  enum
  {
    MAXLINESIZE = 1000
  };
  
protected:
  BorderLine line;
  
public:
  // constructor and destructor
  BorderDialog(unsigned int value);
	
  // retrieve values
  unsigned int GetValue();
  
  // routines necessary for all dialogs
  virtual LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);

  void InitDialog();
  void GetDialog();

  virtual void InitLineShape();
  virtual void GetLineShape();

  void InitLineType();
  void GetLineType();
  
  void InitLineWidth();
  void GetLineWidth();
  
  virtual void InitAlignment() = 0;
  virtual void GetAlignment() = 0;

  virtual void InitOther();

  virtual void xEnable(int);
  virtual void Enable();
};

class TextBorderDialog 
  : public BorderDialog
{
public:
  TextBorderDialog(unsigned int value);
  
  // routines which subclasses of BorderDialog must define
  void InitAlignment();
  void GetAlignment();
  void Enable();
};

class ParBorderDialog 
  : public BorderDialog
{
  unsigned int value;
  
public:
  ParBorderDialog(unsigned int value);

  // routines which subclasses of BorderDialog must define
  void InitAlignment();
  void GetAlignment();
  void Enable();
};

class LineBorderDialog 
  : public BorderDialog
{
public:
  enum
  {
    DEFAULT_LINE,
    DEFAULT_TABLE,
    SPECIFIC_LINE,
  };
  
  int type;
    
public:
  LineBorderDialog(unsigned int value, int type);
	
protected:
  // routines necessary for all dialogs
  virtual LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);

  // routines which subclasses of BorderDialog must define
  void InitAlignment();
  void GetAlignment();
  void EnableAlignment(int);
  void InitLineShape();
  void GetLineShape();
  void xEnable(int);
};


class FrameBorderDialog 
  : public BorderDialog
{
  // The other border dialog boxes always deal with only one
  // guy at a time.  Frames have FOUR borders involved.  We keep
  // the extra information here.
  
  BorderLine line_left, line_right, line_below;
  
  EditFrame::TargetLine target;

public:
  FrameBorderDialog(unsigned int value_above, 
		     unsigned int value_left, 
		     unsigned int value_right, 
		     unsigned int value_below);
	
  // Get results
  void GetValues(unsigned int& up, unsigned int& left, 
		  unsigned int& right, unsigned int& bot,
		  unsigned int& inter, EditFrame::TargetLine& target);

protected:
  // routines necessary for all dialogs
  virtual LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
  
  // routines which subclasses of BorderDialog must define
  void InitAlignment();
  void GetAlignment();
  void EnableAlignment(int);
  void InitOther();
  void InitLineShape();
  void GetLineShape();
  void xEnable(int setting);
};

#endif /* BORDERDIALOG_H */
