// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: borders.h,v 3.3 2000/05/04 13:44:02 kudou Exp $
// BorderEntry is a class which defines objects which are unique
// combinations of border line attributes, used to underline and
// overline characters, paragraphs, and frame borders.

#ifndef BORDERS_H
#define BORDERS_H

#include "generics.h"
#include "borderli.h"

class BorderEntry
  : public GenericEntry
{
  friend class BaseBorderTable;
  
  BorderLine line;

public:
  BorderEntry();
  BorderEntry(BorderLine &bl);
  BorderEntry(BorderEntry&);	// copy constructor

private:
  unsigned char NEAR GetHash();
public:
  BorderLine& GetBorderLine() { return line; }
  friend int operator == (BorderEntry&, BorderEntry&);
  void WriteToStream(PStream*);
  void ReadFromStream(PStream*);
  unsigned int Enter();
#ifndef NDEBUG
  void Dump(unsigned int i, void*);
  static void DumpHeader(FILE* f);
#endif
};

inline
BorderEntry::BorderEntry()
{
}

#define T BorderEntry
#define TABLE BaseBorderTable
#define SEG BaseBorderTableSeg
#define DO_READ_WRITE
#include "tabletem.h"

class BorderTable
  : public BaseBorderTable
{
public:
  void Init();
};

extern BorderTable STATIC_NEAR GlobalBorderTable;

#endif /* BORDERS_H */
