// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: bound.h,v 3.3 2000/05/04 13:44:02 kudou Exp $
// bound buffer

#ifndef BOUND_H
#define BOUND_H

// superclasses
#include "base.h"

class BoundBufferPointer
{
  //friend BufferPointer;
  friend class BP;
  
  long par_id;
  int byte_offset;

public:
  BoundBufferPointer();
  BoundBufferPointer(long, int position);
  BoundBufferPointer(BoundBufferPointer&);

  // read a buffer pointer from a stream
  BoundBufferPointer(PStream*);
  
  // this constructor "binds" the buffer pointer
  BoundBufferPointer(BufferPointer&);

  void Init();
  ~BoundBufferPointer();

public:
  long GetParID() { return(this->par_id); }
  void ReadFromStream(PStream*);
  void WriteToStream(PStream*);
  int EQ(BoundBufferPointer&);
};


// A bound interval is a special type of interval which contains
// weird buffer pointers which are combinations of paragraph number
// and offset in the paragraph.

class BoundInterval
  : public BaseInterval
{
  friend class Interval;
  friend class BoundIntervalList;
  
  BoundBufferPointer BP0;
  BoundBufferPointer BP1;
  udword textflow_serial;
  TextFlow* textflow;
  
public:
  // this constructors copy the interval
  BoundInterval(BoundInterval*);
  BoundInterval(BoundInterval&);
  
  // this constructor binds the interval
  BoundInterval(Interval&);
  
  // this constructor reads the interval from a stream
  BoundInterval(PStream*);
  
  void Init();
  void PostInit();
  virtual ~BoundInterval();
  BoundBufferPointer& GetBP0();
  BoundBufferPointer& GetBP1();
  TextFlow* GetTextFlow();
  udword GetTextFlowSerial();
  void WriteToStream(PStream*);
  void ReadFromStream(PStream*);
  int EQ(BaseInterval&);
};

class BoundIntervalList
  : public BaseIntervalList
{
  BaseInterval* NewMember(BaseInterval*);
  
public:
  // create an unbound interval list  
  IntervalList* Unbind(DocumentContent*);
  void WeedDeadTextFlow(TextFlow*);
  void WriteToStream(PStream*);
  void ReadFromStream(PStream*);
  bool ContainsTextFlow(TextFlow*);
};

#endif /* BOUND_H */
