// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: caret.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// caret

#include "pword.h"
#include "caret.h"
#include "pref.h"
#include "rect.h"
#include "screen.h"
#include "xstr.h"

HWND STATIC_NEAR Caret::window = 0;
HBITMAP STATIC_NEAR Caret::bitmap = 0;
CaretMetric STATIC_NEAR Caret::metric;

Enum_Desc caret_type_desc[] =
{
  { S_caret_bar,	CARET_TYPE_BAR, },
  { S_caret_box,	CARET_TYPE_FRAME, },
  { S_caret_rect,	CARET_TYPE_BOX, },
  { S_caret2_bar,	CARET_TYPE_BAR, },
  { S_caret2_box,	CARET_TYPE_FRAME, },
  { S_caret2_rect,	CARET_TYPE_BOX, },
  { NULL,		CARET_TYPE_BAR, },
};

void
Caret::Kill()
{
  if (Caret::window != 0)
  {
    ::DestroyCaret();
    Caret::window = 0;
  }
}

void
Caret::KillAllResources()
{
  Caret::Kill();
  if (Caret::bitmap != 0)
  {
    ::DeleteObject(Caret::bitmap);
    Caret::bitmap = 0;
  }
}

void
Caret::Reset(HWND window)
{
  if (Caret::window == window)
  {
    Caret::Kill();
  }
}

CaretMetric
Caret::GetCaretMetric(int width, int ascent, int descent, int flags)
{
  CaretMetric m;
  SET_MAX(ascent, 1);
  SET_MAX(width, 1);
  if (flags & Caret::OVERFLOW)
  {
    m.flags = Caret::OVERFLOW;
    ascent /= 4;
    SET_MAX(ascent, 2);
    m.base_width = 0;
    m.ascent = ascent;
    m.descent = ascent * 2;
    m.overhang = 0;
    m.crossbar_width = 0;
    m.lwidth = ascent;
    m.rwidth = ascent * 2;
  }
  else if (flags & Caret::LINERIGHT)
  {
    m.flags = Caret::LINERIGHT;
    SET_MAX(ascent, 4);
    ascent &= ~1;
    m.base_width = 0;
    m.ascent = ascent;
    m.descent = 0;
    m.overhang = 0;
    m.crossbar_width = 0;
    m.lwidth = 0;
    m.rwidth = ascent / 2;
  }
  else
  {
    m.flags = flags;
    m.base_width = 0;
    m.ascent = ascent;
    m.descent = descent;
    m.overhang = 0;
    m.crossbar_width = 0;
    m.lwidth = 0;
    m.rwidth = width;
    switch (Pref_caret_type)
    {
     case CARET_TYPE_BOX:
      break;
      
     case CARET_TYPE_FRAME:
       // We must make difference for CARET_TYPE_BOX and CARET_TYPE_FRAME.
      m.base_width = Pref_caret_width;
      break;

     default:
      {
	int base_width = ceil_log2(width) - 1;
	SET_MAX(base_width, Pref_caret_width);
	m.base_width = base_width;
	int height = ascent;
	m.ascent = height;
	m.descent = 0;
	if (flags & Caret::UNDERLINE)
	{
	  ascent += base_width;
	  m.descent = base_width;
	}
	m.overhang = (flags & Caret::ITALIC) ? (height - 1) / 2 : 0;
	m.crossbar_width = ((flags & (Caret::UNDERLINE | Caret::STRIKEOUT))
			    ? base_width * 2 : 0);
	m.lwidth = base_width / 2 + m.crossbar_width;
	m.rwidth = (base_width
		    + m.crossbar_width
		    + MAX(m.crossbar_width, m.overhang) - m.lwidth);
      }
      break;
    }
  }
  if (flags & Caret::TATEGAKI)
  {
    int lwidth = m.lwidth;
    int rwidth = m.rwidth;
    m.lwidth = m.descent;
    m.rwidth = m.ascent;
    m.ascent = lwidth;
    m.descent = rwidth;
  }
  return(m);
}

static void NEAR
move_and_line(HDC dc, Dpoint* dp)
{
#ifdef _WIN32
  MoveToEx(dc, POINT_X(&dp[0]), POINT_Y(&dp[0]), NULL);
#else /* _WIN32 */
  MoveTo(dc, POINT_X(&dp[0]), POINT_Y(&dp[0]));
#endif /* _WIN32 */
  LineTo(dc, POINT_X(&dp[1]), POINT_Y(&dp[1]));
}

void
Caret::Set(HWND window,
	    int x, int y, int width, int ascent, int descent, int flags)
{
  Caret::Kill();
  CaretMetric m = Caret::GetCaretMetric(width, ascent, descent, flags);
  if (Caret::bitmap == 0
      || memcmp(&Caret::metric, &m, sizeof(CaretMetric)) != 0)
  {
    Caret::KillAllResources();
    Caret::metric = m;
    
    int width = m.lwidth + m.rwidth;
    int height = m.ascent + m.descent;
    HDC dc = ::CreateCompatibleDC(Screen::dc);
    Caret::bitmap = ::CreateCompatibleBitmap(dc, width, height);
    if (Caret::bitmap != 0)
    {
      Dpoint points[3];
      
      ::SelectObject(dc, Caret::bitmap);
      
      RECT r;
      r.left = 0;
      r.right = width;
      r.top = 0;
      r.bottom = height;
      switch (Pref_caret_type)
      {
       case CARET_TYPE_FRAME:
       case CARET_TYPE_BOX:
	{
	  ::FillRect(dc, &r, Screen::stocked_white_brush);
	  if (Pref_caret_type == CARET_TYPE_FRAME)
	  {
	    r.left += Pref_caret_width;
	    r.right -= Pref_caret_width;
	    r.top += Pref_caret_width;
	    r.bottom -= Pref_caret_width;
	    if (r.left < r.right && r.top < r.bottom)
	    {
	      ::FillRect(dc, &r, Screen::stocked_black_brush);
	    }
	  }
	}
	break;

       default:
	{
	  ::FillRect(dc, &r, Screen::stocked_black_brush);
	  
	  int index_x = INDEX_X;
	  if (m.flags & Caret::TATEGAKI)
	  {
	    index_x = INDEX_Y;
	    int ascent = m.ascent;
	    int descent = m.descent;
	    m.ascent = m.rwidth;
	    m.descent = m.lwidth;
	    m.lwidth = m.ascent;
	    m.rwidth = m.descent;
	    SetMapMode(dc, MM_ANISOTROPIC);
#ifdef _WIN32
	    SetWindowExtEx(dc, 1, 1, NULL);
#else /* _WIN32 */
	    SetWindowExt(dc, 1, 1);
#endif /* _WIN32 */ 
#ifdef _WIN32
	    SetViewportExtEx(dc, -1, 1, NULL);
#else /* _WIN32 */
	    SetViewportExt(dc, -1, 1);
#endif /* _WIN32 */
#ifdef _WIN32
	    SetViewportOrgEx(dc, width, 0, NULL);
#else /* _WIN32 */
	    SetViewportOrg(dc, width, 0);
#endif /* _WIN32 */
	    height = width;
	    width = ascent + descent;
	  }
	  int index_y = REVERSED_INDEX(index_x);
	  
	  if (flags & Caret::OVERFLOW)
	  {
	    int size = m.ascent + m.descent;
	    POINT_UNIT(&points[0], index_x) = 0;
	    POINT_UNIT(&points[0], index_y) = 0;
	    POINT_UNIT(&points[1], index_x) = size / 2;
	    POINT_UNIT(&points[1], index_y) = size;
	    POINT_UNIT(&points[2], index_x) = size;
	    POINT_UNIT(&points[2], index_y) = 0;
	    ::Polygon(dc, CastDpointToWindowsPOINT(points), 3);
	  }
	  else if (flags & Caret::LINERIGHT)
	  {
	    POINT_UNIT(&points[0], index_x) = 0;
	    POINT_UNIT(&points[0], index_y) = 0;
	    POINT_UNIT(&points[1], index_x) = m.ascent / 2;
	    POINT_UNIT(&points[1], index_y) = m.ascent / 2;
	    POINT_UNIT(&points[2], index_x) = 0;
	    POINT_UNIT(&points[2], index_y) = m.ascent;
	    ::Polygon(dc, CastDpointToWindowsPOINT(points), 3);
	  }
	  else
	  {
	    HPEN pen = ::CreatePen(((flags & Caret::HIDDEN) ? PS_DOT
				     : PS_SOLID),
				    m.base_width, RGB(255, 255, 255));
	    HPEN old_pen = (HPEN)::SelectObject(dc, pen);
	    
	    // ready to draw the vertical part of the caret.  Remember
	    // this is the default MM_TEXT mode, y increases from top to
	    // bottom
	    POINT_UNIT(&points[0], index_x) = (m.crossbar_width
						+ m.base_width / 2);
	    POINT_UNIT(&points[0], index_y) = height;
	    POINT_UNIT(&points[1], index_x) = (m.crossbar_width
						+ m.base_width / 2
						+ m.overhang);
	    POINT_UNIT(&points[1], index_y) = 0;
	    move_and_line(dc, points);
	    
	    // next we draw the underline and/or strikeout
	    if (flags & Caret::UNDERLINE)
	    {
	      POINT_UNIT(&points[0], index_x) = 0;
	      POINT_UNIT(&points[0], index_y) = height - m.base_width / 2;
	      POINT_UNIT(&points[1], index_x) = (m.base_width
						  + m.crossbar_width * 2);
	      POINT_UNIT(&points[1], index_y) = height - m.base_width / 2;
	      move_and_line(dc, points);
	    }
	    if (flags & Caret::STRIKEOUT)
	    {
	      POINT_UNIT(&points[0], index_x) = m.overhang / 2;
	      POINT_UNIT(&points[0], index_y) = height / 2;
	      POINT_UNIT(&points[1], index_x) = (m.base_width
						  + m.crossbar_width * 2
						  + m.overhang / 2);
	      POINT_UNIT(&points[1], index_y) = height / 2;
	      move_and_line(dc, points);
	    }
	    ::SelectObject(dc, old_pen);
	    ::DeleteObject(pen);
	  }
	}
	break;
      }
    }
    ::DeleteDC(dc);
  }
  Caret::window = window;
  ::CreateCaret(window, Caret::bitmap, 0, 0);
  ::SetCaretPos(x, y);
  ::ShowCaret(0);
}
