// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: commlist.h,v 2.1 1999/02/27 13:49:36 kudou Ex
// list classes common methods

#ifdef LIST_METHODS
// these methods are the list classes common methods

// push data, data is pushed in first position
// data	: push data
void Push(void* data);

// pop data, data is poped from first position
// return	: poped data
void* Pop();

// push data to last
// data	: push data
void Inject(void* data);

// pop last data
// return	: poped data
void* Eject();

// number, how meny items are resistered?
// return	: number of item
uword Number();

// get top data
// return	: first items data
void* GetTopData();

// search data, return index
// data	: serch data
// return	: find index. if 0, can not find.
uword Search(void* data);

// delete first find data
// data	: delete data
void Delete(void* data);

// delete data with index
// n		: index
void Delete(uword n);

// access with index(1~)
// n		: index
void* Access(uword n);

// access with index - 1(0~), like array
// n		: index - 1
// return	: value
void* operator [] (uword n);

// replace data with index
// n		: index
// data	: replace data
void Replace(uword n, void* data);

// insert data
// prev	: prev data position. if 0, insert first position
// data	: insert data
void Insert(uword prev, void* data);

// insert after first match
// prev	: prev data, if 0, insert first position
// data	: insert data
void Insert(void* prev, void* data);

// clear list
void Clear();

#endif /* LIST_METHODS */


#ifdef LISTITERATOR_METHODS
// these are the list-iterator classes common methods

// iterator
void* operator() ();

// iteration end check
// If you never push(void*)0 data to SingleListItem, you don't 
// have to check the end of list with IsEnd(). When the iteration 
// come end, the iterator returns 0.
bool IsEnd();

// revert to initial
void Revert();

#endif /* LISTITERATOR_METHODS */
