// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: cut.cpp,v 3.3 1999/05/23 17:26:08 kudou Exp $
// class EditFrame
// ͂݃c[iJbgj

#include "pword.h"
#include "editfram.h"
#include "docwindo.h"
#include "fission.h"
#include "mcursor.h"
#include "pmenus.h"
#include "vdisplay.h"
#include "xstr.h"

void NEAR 
EditFrame::Cut_LDWN(WPARAM_T wParam, LPARAM_T lParam)
{
  //
  // cut line
  //
  CancelCut();
  
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  if (LockLayout(mpos) == 0) 
  {
    return;
  }
  Fission* f = FindCutFissionW(mpos);
  MouseCursor::CutClose();
  if (f == 0) 
  {
    ::MessageBeep(0);
    return;
  }
  if (wParam & MK_SHIFT) 
  {
    // get segment
    CrossPoint* start = 0;
    CrossPoint* end = 0;
    Fission* cut_start = 0;
    Fission* cut_end = 0;
    FindSegmentW(f, mpos, start, end);
    if (start == 0 || end == 0) 
    {
      // hit error.
      return;
    }
    if (CanCutSegment(f, start, end) == False) 
    {
      ::MessageBeep(0);
      PWordPresentation::StatusOut(S_CantCut);
      return;
    }
    if (f->GetDir() == Fission::Vertical) 
    {
      cut_start = start->GetHFission();
      cut_end   = end->GetHFission();
    }
    else 
    {               // Fission::Horizontal
      cut_start = start->GetVFission();
      cut_end   = end->GetVFission();
    }
    GetEditFF()->VanishPart(f, cut_start, cut_end);
  }
  else 
  {
    if (CanCut(f) == False) 
    {
      ::MessageBeep(0);
      PWordPresentation::StatusOut(S_CantCut);
      return;
    }
    else 
    {
      // fission cut
      GetEditFF()->Vanish(f);
    }
  }
  UnforceTouchCaret();
  RedrawWindows();
  SetDirty();
}

void NEAR 
EditFrame::Cut_MV(WPARAM_T wParam, LPARAM_T lParam)
{
  //
  // idle
  //
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  if (LockLayout(mpos) == 0) 
  {
    CancelCut();
    return;
  }
  Fission* f;
  if ((f = FindCutFissionW(mpos)) == 0) 
  {
    CancelCut();
    return;
  }
  else 
  {
    CrossPoint* start = 0;
    CrossPoint* end = 0;
    if (wParam & MK_SHIFT) 
    {
      // get segment
      FindSegmentW(f, mpos, start, end);
      if (start == 0 || end == 0) 
      {
	CancelCut();
	return;
      }
    }
    else
    {
      start = f->GetStartCrossPoint();
      end = f->GetEndCrossPoint();
    }
    // cut hole of the line
    MouseCursor::CutOpen();
    if (cut.IsFixed())
    {
      if ((cut.GetLI() != GetEditLI()) ||
	  (cut.GetFission() != f) ||
	  (cut.GetStart() != start) ||
	  (cut.GetEnd() != end))
      {
	RedisplayCutLine();		// vanish
	cut.FindCutLine(GetEditLI(), f, start, end);
	RedisplayCutLine();		// draw
      }
    }
    else
    {
      cut.FindCutLine(GetEditLI(), f, start, end);
      RedisplayCutLine();		// draw
    }
  }
}

// cut frame mode
void
EditFrame::WndProcCut(DocumentWindow* window,
		       MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  EditFrame::window = window;
  switch (Msg) 
  {
   case WM_MOUSEMOVE:
    Cut_MV(wParam, lParam);
    break;
    
   case WM_LBUTTONDOWN:
    Cut_LDWN(wParam, lParam);
    break;
  }
}

void 
EditFrame::CancelCut(bool beep)
{
  if (cut.IsFixed())
  {
    RedisplayCutLine();	// vanish
  }
  cut.Reset();
  MouseCursor::CutClose();
  if (beep)
  {
    ::MessageBeep(0);
  }
}

void 
EditFrame::RedisplayCutLine()
{
  HWND hWnd = window->GetHandle();
  HDC hDC = GetDC(hWnd);
  RedisplayCutLine(hDC);
  ReleaseDC(hWnd, hDC);
}

void 
EditFrame::RedisplayCutLine(VDisplay* vdsp)
{
  RedisplayCutLine(vdsp->GetDC());
}

void 
EditFrame::RedisplayCutLine(HDC hDC)
{
  if (!cut.IsFixed() ||
      (GetEditLI() == 0))
  {
    return;
  }
  VectW start;
  VectW end;
  if (cut.GetFission()->GetDir() == Fission::Vertical) 
  {
    start = ItoWv(Vector(((VFission*)cut.GetFission())->X(),
			   cut.GetStart()->Y()), 
		   cut.GetLI());
    end   = ItoWv(Vector(((VFission*)cut.GetFission())->X(),
			   cut.GetEnd()->Y()),
		   cut.GetLI());
  }
  else 
  {
    start = ItoWv(Vector(cut.GetStart()->X(),
			   ((HFission*)cut.GetFission())->Y()),
		   cut.GetLI());
    end   = ItoWv(Vector(cut.GetEnd()->X(),
			   ((HFission*)cut.GetFission())->Y()),
		   cut.GetLI());
  }
  DisplaySelectedLine(hDC, start, end);
}
