// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: ddisplay.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// Debug Display class

#if (!defined(NDEBUG))

#include "pword.h"
#include "ddisplay.h"
#include "debugcnf.h"
#include <stdarg.h>
#include <time.h>

uword DebugDisplay::indent = 3;

DebugDisplay::DebugDisplay(char* debug_file)
{
  if (debug_file == 0) 
  {
    debug_file = DebugCnf::GetLogFileName();
    if (debug_file == 0) 
    {
      debug_file = "debug.dsp";
    }
  }
  nest_level = 0;
  fp = fopen(debug_file, "a");
  Printf("[ pWord Debug Display ]\n");
  time_t tod;
  time(&tod);
  Printf(ctime(&tod));
  Printf("\n");
}

DebugDisplay::~DebugDisplay()
{
  Printf("\n\n");
  if (fp != 0) 
  {
    fclose(fp);
  }
}

void CDECL
DebugDisplay::Printf(char* format, ...)
{
  if (fp != 0) 
  {
    uword nest = indent * nest_level;
    for (uword i = 0; i < nest; i++) 
    {
      fprintf(fp, " ");
    }
    va_list va;
    va_start(va, format);
    vfprintf(fp, format, va);
    va_end(va);
  }
}

DebugDisplay* DebugDisplay::Open(char* file_name)
{
  return new DebugDisplay(file_name);
}

DebugDisplay* DebugDisplay::Open(DebugDisplay* dd)
{
  if (dd == 0) 
  {
    dd = new DebugDisplay();
  }
  else 
  {
    dd->nest_level++;
  }
  return dd;
}

void
DebugDisplay::Close(DebugDisplay* dd)
{
  if (dd->nest_level == 0) 
  {
    delete dd;
  }
  else 
  {
    dd->nest_level--;
  }
}

bool
DebugDisplay::DoClassDebug(char* class_name)
{
  return DebugCnf::DoClassDebug(class_name);
}

bool
DebugDisplay::DoItemDebug(char* item_name)
{
  return DebugCnf::DoItemDebug(item_name);
}

#endif /* NDEBUG */
