// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: ddisplay.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// Debug Display class

#ifndef DDISPLAY_H
#define DDISPLAY_H

#if (!defined(NDEBUG))

class DebugDisplay
{
  // file pointer
  FILE* fp;
  
  // nest level
  uword nest_level;
  
  // indent columns
  static uword indent;
  
private:
  // constructor
  DebugDisplay(char* debug_file = 0);
  
  // destructor
  ~DebugDisplay();
  
public:
  // print out by format string.
  void CDECL Printf(char* format, ...);
  
  // open display with file name, it's a Objective-C like constructor.
  static DebugDisplay* Open(char* file_name);
  
  // open display
  static DebugDisplay* Open(DebugDisplay* dd = 0);
  
  // close display
  static void Close(DebugDisplay* dd);
  
  // class debug check
  static bool DoClassDebug(char* class_name);
  
  // item debug check
  static bool DoItemDebug(char* item_name);
};
#endif

#endif /* DDISPLAY_H */
